/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalVersion;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.TextPropertyScribe;
import biweekly.property.Transparency;

public class TransparencyScribe
extends TextPropertyScribe<Transparency> {
    public TransparencyScribe() {
        super(Transparency.class, "TRANSP");
    }

    @Override
    protected String _writeText(Transparency property, WriteContext context) {
        if (context.getVersion() == ICalVersion.V1_0) {
            if (property.isOpaque()) {
                return "0";
            }
            if (property.isTransparent()) {
                return "1";
            }
        }
        return super._writeText(property, context);
    }

    @Override
    protected Transparency newInstance(String value, ICalVersion version) {
        if (version == ICalVersion.V1_0) {
            try {
                int intValue = Integer.parseInt(value);
                switch (intValue) {
                    case 0: {
                        return Transparency.opaque();
                    }
                    case 1: {
                        return Transparency.transparent();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Transparency(value);
    }
}

