/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.component;

import biweekly.ICalVersion;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public abstract class ICalComponentScribe<T extends ICalComponent> {
    private static final Set<ICalVersion> allVersions = Collections.unmodifiableSet(EnumSet.allOf(ICalVersion.class));
    protected final Class<T> clazz;
    protected final String componentName;

    protected ICalComponentScribe(Class<T> clazz, String componentName) {
        this.clazz = clazz;
        this.componentName = componentName;
    }

    public Set<ICalVersion> getSupportedVersions() {
        return allVersions;
    }

    public Class<T> getComponentClass() {
        return this.clazz;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public T emptyInstance() {
        T component = this._newInstance();
        ((ICalComponent)component).getProperties().clear();
        ((ICalComponent)component).getComponents().clear();
        return component;
    }

    protected abstract T _newInstance();

    public List<ICalComponent> getComponents(T component) {
        return new ArrayList<ICalComponent>(((ICalComponent)component).getComponents().values());
    }

    public List<ICalProperty> getProperties(T component) {
        return new ArrayList<ICalProperty>(((ICalComponent)component).getProperties().values());
    }

    public void checkForDataModelConversions(T component, ICalComponent parent, ICalVersion version) {
    }
}

