/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.util.Duration;
import biweekly.util.ICalDate;
import java.util.Date;

public final class Period {
    private final ICalDate startDate;
    private final ICalDate endDate;
    private final Duration duration;

    public Period(Date startDate, Date endDate) {
        this(startDate == null ? null : new ICalDate(startDate), endDate == null ? null : new ICalDate(endDate));
    }

    public Period(ICalDate startDate, ICalDate endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.duration = null;
    }

    public Period(Date startDate, Duration duration) {
        this(startDate == null ? null : new ICalDate(startDate), duration);
    }

    public Period(ICalDate startDate, Duration duration) {
        this.startDate = startDate;
        this.duration = duration;
        this.endDate = null;
    }

    public Period(Period period) {
        this.startDate = period.startDate == null ? null : new ICalDate(period.startDate);
        this.endDate = period.endDate == null ? null : new ICalDate(period.endDate);
        this.duration = period.duration;
    }

    public ICalDate getStartDate() {
        return this.startDate;
    }

    public ICalDate getEndDate() {
        return this.endDate;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Period other = (Period)obj;
        if (this.duration == null ? other.duration != null : !this.duration.equals(other.duration)) {
            return false;
        }
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
    }
}

