/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.DateOrDateTimeProperty;
import biweekly.property.ICalProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.ICalDate;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;

public abstract class DateOrDateTimePropertyScribe<T extends DateOrDateTimeProperty>
extends ICalPropertyScribe<T> {
    protected DateOrDateTimePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.DATE_TIME);
    }

    @Override
    protected ICalParameters _prepareParameters(T property, WriteContext context) {
        ICalDate value = (ICalDate)((ValuedProperty)property).getValue();
        if (value == null) {
            return ((ICalProperty)property).getParameters();
        }
        return DateOrDateTimePropertyScribe.handleTzidParameter(property, value.hasTime(), context);
    }

    @Override
    protected ICalDataType _dataType(T property, ICalVersion version) {
        ICalDate value = (ICalDate)((ValuedProperty)property).getValue();
        if (value == null) {
            return ICalDataType.DATE_TIME;
        }
        return value.hasTime() ? ICalDataType.DATE_TIME : ICalDataType.DATE;
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        ICalDate value = (ICalDate)((ValuedProperty)property).getValue();
        return DateOrDateTimePropertyScribe.date(value, property, context).extended(false).write();
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape((String)value);
        return this.parse(value, parameters, context);
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        ICalDataType dataType = this.dataType(property, null);
        ICalDate value = (ICalDate)((ValuedProperty)property).getValue();
        String dateStr = DateOrDateTimePropertyScribe.date(value, property, context).extended(true).write();
        element.append(dataType, dateStr);
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        String value = element.first(ICalDataType.DATE_TIME);
        if (value == null) {
            value = element.first(ICalDataType.DATE);
        }
        if (value != null) {
            return this.parse(value, parameters, context);
        }
        throw DateOrDateTimePropertyScribe.missingXmlElements(ICalDataType.DATE_TIME, ICalDataType.DATE);
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        ICalDate value = (ICalDate)((ValuedProperty)property).getValue();
        String dateStr = DateOrDateTimePropertyScribe.date(value, property, context).extended(true).write();
        return JCalValue.single(dateStr);
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        return this.parse(valueStr, parameters, context);
    }

    protected abstract T newInstance(ICalDate var1);

    private T parse(String value, ICalParameters parameters, ParseContext context) {
        ICalDate date;
        if (value == null) {
            return this.newInstance(null);
        }
        try {
            date = DateOrDateTimePropertyScribe.date(value).parse();
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(17, new Object[0]);
        }
        T property = this.newInstance(date);
        context.addDate(date, (ICalProperty)property, parameters);
        return property;
    }
}

