/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.autolinking.server;

import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.TableConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugins.autolinking.plugin.AutoLinkingServerPlugin;
import com.inet.helpdesk.plugins.autolinking.server.AutoLinkEntry;
import com.inet.helpdesk.plugins.autolinking.server.AutoLinkValue;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AutoLinkingStructureProvider
extends AbstractStructureProvider {
    static final String CAT_AUTOLINKING = "cat_autolinking";
    static final String PROP_GROUP_AUTOLINKING = "pg_autolinking";

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if (advanced && groupKey.equals("ticketsettings")) {
            categories.add(new ConfigCategory(138, CAT_AUTOLINKING, this.translate(settings, "autolinking.category", new Object[0]), "configuration.autolinking"));
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        if (categoryKey.equals(CAT_AUTOLINKING)) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/autolinking/plugin/autolinking_48.png");
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if (categoryKey.equals(CAT_AUTOLINKING)) {
            configPropertyGroups.add(new ConfigPropertyGroup(1, PROP_GROUP_AUTOLINKING));
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if (propertyGroupKey.equals(PROP_GROUP_AUTOLINKING)) {
            this.addTo(configProperties, "autolinking.label", "Label", settings);
            this.addTo(configProperties, "autolinking.placeholders", "Label", settings);
            this.addTo(configProperties, "autolinking.placeholders2", "Label", settings);
            List<String[]> values = this.getCurrentOrSavedValue(settings);
            ConfigProperty[] columns = new ConfigProperty[]{new ConfigProperty(0, "", "SimpleText", this.translate(settings, "autolinking.column.expression", new Object[0]), null, null, null), new ConfigProperty(1, "", "SimpleText", this.translate(settings, "autolinking.column.replacement", new Object[0]), null, null, null)};
            ConfigAction[] actions = new ConfigAction[]{new ConfigAction(this.translate(settings, "autolinking.add", new Object[0]))};
            TableConfigProperty table = new TableConfigProperty(configProperties.size() * 100, AutoLinkingServerPlugin.CONFIG_AUTO_LINKS.getKey(), "", null, null, values, columns, new int[]{50, 50}, actions, null);
            table.setSortable(true);
            configProperties.add((ConfigProperty)table);
        }
    }

    /*
     * Exception decompiling
     */
    private List<String[]> getCurrentOrSavedValue(ConfigStructureSettings settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        List<String[]> value;
        if (CAT_AUTOLINKING.equals(categoryKey) && (value = this.getCurrentOrSavedValue(settings)) != null) {
            for (String[] row : value) {
                String expression = row[0];
                String replacement = row[1];
                if (StringFunctions.isEmpty((String)expression) || StringFunctions.isEmpty((String)replacement)) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "autolinking.error.emptyExpressionOrLink", new Object[0]), AutoLinkingServerPlugin.CONFIG_AUTO_LINKS));
                }
                try {
                    Pattern pattern = Pattern.compile(expression);
                    Matcher matcher = pattern.matcher("test123");
                    if (matcher.groupCount() < 1) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "autolinking.error.noidmatcher", new Object[]{expression}), AutoLinkingServerPlugin.CONFIG_AUTO_LINKS));
                    }
                    if (pattern.matcher("1").matches() || pattern.matcher("12").matches() || pattern.matcher("123").matches()) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "autolinking.error.cannotMatchOnlxNumbers", new Object[]{expression}), AutoLinkingServerPlugin.CONFIG_AUTO_LINKS));
                    }
                }
                catch (PatternSyntaxException ex) {
                    HDLogger.debug((Object)ex);
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "autolinking.error.invalidpattern", new Object[]{expression, ex.getMessage()}), AutoLinkingServerPlugin.CONFIG_AUTO_LINKS));
                }
                if (!expression.matches(".*[^\\\\]\\.[\\+\\*].*")) continue;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Warning, this.translate(settings, "autolinking.error.dotInExpression", new Object[]{expression}), AutoLinkingServerPlugin.CONFIG_AUTO_LINKS));
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        if (key.equals(AutoLinkingServerPlugin.CONFIG_AUTO_LINKS.getKey())) {
            String[][] rows = (String[][])new Json().fromJson(value, String[][].class);
            AutoLinkValue autoLinkValue = new AutoLinkValue();
            for (String[] row : rows) {
                autoLinkValue.add(new AutoLinkEntry(row[0], row[1]));
            }
            settings.save(AutoLinkingServerPlugin.CONFIG_AUTO_LINKS, new Json().toJson((Object)autoLinkValue));
            return ConfigStructure.SaveState.SAVE;
        }
        return super.save(key, value, settings);
    }
}

