/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.autolinking.server;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.plugins.autolinking.plugin.AutoLinkingServerPlugin;
import com.inet.helpdesk.plugins.autolinking.server.AutoLinkEntry;
import com.inet.helpdesk.plugins.autolinking.server.AutoLinkValue;
import com.inet.helpdesk.plugins.ticketlist.api.display.TicketTextRenderExtension;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.list.PairList;
import com.inet.lib.util.EncodingFunctions;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class AutoLinkExtension
implements TicketTextRenderExtension {
    private static final String NEGATIVE_LOOKAHEAD = "(?![^<]*>|[^<>]*<\\/a)";
    private static final Pattern PAT_HTML_ENTITIES = Pattern.compile("&([a-z0-9]+|#[0-9]{1,6}|#x[0-9a-fA-F]{1,6});");
    private static final ConfigValue<String> SERVER_URL = new ConfigValue(ConfigKey.SERVER_URL);
    private static final ConfigValue<AutoLinkValue> AUTO_LINKS = new ConfigValue(AutoLinkingServerPlugin.CONFIG_AUTO_LINKS);

    public void changeTicketTextForViewing(@Nonnull MutableReaStepText stepText) {
        this.findAndPatchLinks(stepText);
    }

    private void findAndPatchLinks(MutableReaStepText text) {
        if (text.isHtml() && !text.getText().isEmpty()) {
            for (AutoLinkEntry autoLink : (AutoLinkValue)AUTO_LINKS.get()) {
                PairList htmlEntities = null;
                Pattern p = Pattern.compile(autoLink.getExpression() + NEGATIVE_LOOKAHEAD);
                Matcher m = p.matcher(text.getText());
                if (!m.find()) continue;
                StringBuilder sb = new StringBuilder();
                htmlEntities = new PairList();
                Matcher htmlEntitymatcher = PAT_HTML_ENTITIES.matcher(text.getText());
                while (htmlEntitymatcher.find()) {
                    htmlEntities.add((Object)htmlEntitymatcher.start(), (Object)htmlEntitymatcher.end());
                }
                do {
                    if (!this.isInsideHtmlEntity(m.start(), m.end(), (PairList<Integer, Integer>)htmlEntities)) {
                        String id = m.group(1);
                        String link = this.replacePlaceholder(autoLink.getReplacement(), id);
                        m.appendReplacement(sb, "<a target=\"_blank\" href=\"" + link + "\">" + m.group() + "</a>");
                        continue;
                    }
                    m.appendReplacement(sb, m.group());
                } while (m.find());
                m.appendTail(sb);
                text.setText(sb.toString());
            }
        }
    }

    private boolean isInsideHtmlEntity(int start, int end, PairList<Integer, Integer> htmlEntities) {
        for (int i = 0; i < htmlEntities.size(); ++i) {
            int entityEnd = (Integer)htmlEntities.get(i).getSecond();
            int entityStart = (Integer)htmlEntities.get(i).getFirst();
            if (start > entityStart && start < entityEnd || end > entityStart && end < entityEnd) {
                return true;
            }
            if ((Integer)htmlEntities.get(i).getFirst() <= end) continue;
            return false;
        }
        return false;
    }

    private String replacePlaceholder(String replacement, String id) {
        int paramIndex = replacement.indexOf(63);
        while (replacement.contains("{id}")) {
            int index = replacement.indexOf("{id}");
            if (index < paramIndex || paramIndex == -1 || replacement.startsWith("mailto:")) {
                replacement = replacement.replaceFirst("\\{id\\}", EncodingFunctions.encodeUrlPath((String)id));
                continue;
            }
            replacement = replacement.replaceFirst("\\{id\\}", EncodingFunctions.encodeUrlParameter((String)id));
        }
        if (replacement.contains("{id_int}")) {
            AtomicInteger id_int = new AtomicInteger();
            Consumer<NumberFormat> parser = format -> {
                ParsePosition pos;
                Number parse;
                if (id_int.get() == 0 && (parse = format.parse(id, pos = new ParsePosition(0))) != null && pos.getIndex() == id.length() && pos.getErrorIndex() == -1) {
                    int value = parse.intValue();
                    id_int.set(value);
                }
            };
            parser.accept(NumberFormat.getIntegerInstance(ClientLocale.getThreadLocale()));
            parser.accept(NumberFormat.getIntegerInstance(Locale.ENGLISH));
            parser.accept(NumberFormat.getIntegerInstance(Locale.GERMAN));
            if (id_int.get() == 0) {
                try {
                    id_int.set(Integer.valueOf(id));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (id_int.get() != 0) {
                replacement = replacement.replace("{id_int}", id_int.toString());
            }
        }
        if (replacement.contains("{serverurl}")) {
            String url = (String)SERVER_URL.get();
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            replacement = replacement.replace("{serverurl}", url);
        }
        return replacement;
    }
}

