/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.twofactor.server.totp;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.inet.authentication.twofactor.TwoFactorAuthenticationServerPlugin;
import com.inet.authentication.twofactor.api.TwoFactorProvider;
import com.inet.authentication.twofactor.server.totp.a;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ApplicationDescription;
import com.inet.usersandgroups.api.user.UserAccount;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class b
implements TwoFactorProvider {
    public String getExtensionName() {
        return "totp";
    }

    @Override
    public String getDisplayName() {
        return TwoFactorAuthenticationServerPlugin.MSG.getMsg("twofactor.totp.displayname", new Object[0]);
    }

    @Override
    public boolean available(UserAccount user) {
        return true;
    }

    @Override
    public String createData(GUID accountID) {
        byte[] byArray = new byte[20];
        new SecureRandom().nextBytes(byArray);
        return new String(byArray, StandardCharsets.ISO_8859_1);
    }

    @Override
    public String showCurrentSettings(@Nonnull UserAccount user, String data, boolean isNew) {
        byte[] byArray = data.getBytes(StandardCharsets.ISO_8859_1);
        String string = this.a(user, byArray);
        String string2 = TwoFactorAuthenticationServerPlugin.MSG.getMsg("twofactor.totp.instructions", new Object[0]);
        StringBuilder stringBuilder = new StringBuilder(StringFunctions.encodeHTML((String)string2, (boolean)false) + "<br><br><center><strong>" + StringFunctions.encodeHTML((String)ApplicationDescription.get().getRemoteGuiInformation().getTitle(), (boolean)false) + " (" + StringFunctions.encodeHTML((String)user.getDisplayName(), (boolean)false) + ")</strong><br><img src=\"data:image/png;base64,");
        try {
            QRCodeWriter qRCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, 256, 256);
            FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)fastByteArrayOutputStream);
            stringBuilder.append(Base64.getEncoder().encodeToString(fastByteArrayOutputStream.toByteArray()));
            stringBuilder.append("\"><br>");
            stringBuilder.append(StringFunctions.encodeHTML((String)a.a(byArray), (boolean)false));
            stringBuilder.append("</center>");
        }
        catch (Exception exception) {
            ErrorCode.throwAny((Throwable)exception);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean validateTwoFactorCode(String code, String data) {
        long l = System.currentTimeMillis();
        byte[] byArray = data.getBytes(StandardCharsets.ISO_8859_1);
        if (Objects.equals(code, b.a(byArray, l))) {
            return true;
        }
        if (Objects.equals(code, b.a(byArray, l - 30000L))) {
            return true;
        }
        return Objects.equals(code, b.a(byArray, l + 30000L));
    }

    @Nonnull
    private String a(@Nonnull UserAccount userAccount, byte @Nonnull [] byArray) {
        StringBuilder stringBuilder = new StringBuilder("otpauth://totp/");
        String string = userAccount.getDisplayName();
        stringBuilder.append(EncodingFunctions.encodeUrlPath((String)string));
        stringBuilder.append("?secret=");
        stringBuilder.append(a.a(byArray));
        String string2 = ApplicationDescription.get().getRemoteGuiInformation().getTitle();
        stringBuilder.append("&issuer=").append(EncodingFunctions.encodeUrlParameter((String)string2));
        return stringBuilder.toString();
    }

    private static String a(byte[] byArray, long l) {
        try {
            long l2 = l / 30000L;
            byte[] byArray2 = new byte[]{(byte)(l2 >>> 56), (byte)(l2 >>> 48), (byte)(l2 >>> 40), (byte)(l2 >>> 32), (byte)(l2 >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)(l2 >>> 0)};
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(byArray, "RAW"));
            byte[] byArray3 = mac.doFinal(byArray2);
            int n = byArray3[byArray3.length - 1] & 0xF;
            int n2 = (byArray3[n] & 0x7F) << 24 | (byArray3[n + 1] & 0xFF) << 16 | (byArray3[n + 2] & 0xFF) << 8 | byArray3[n + 3] & 0xFF;
            int n3 = n2 % 1000000;
            Object object = Integer.toString(n3);
            while (((String)object).length() < 6) {
                object = "0" + (String)object;
            }
            return object;
        }
        catch (Exception exception) {
            ErrorCode.throwAny((Throwable)exception);
            return null;
        }
    }
}

