'use strict';(function(){clearreportsApp.factory("WebauthnSupport",function(){var $this=this;$this.supported=function(){return!!(navigator.credentials&&navigator.credentials.create&&navigator.credentials.get&&window.PublicKeyCredential&&window.isSecureContext)};$this.isPlatformAuthenticatorAvailable=function(){if(this.supported()&&window.PublicKeyCredential.isUserVerifyingPlatformAuthenticatorAvailable)return window.PublicKeyCredential.isUserVerifyingPlatformAuthenticatorAvailable();return new Promise(function(_a,
r){r()})};$this.isSecurityKeySupported=function(){if(window.PublicKeyCredential!==undefined&&window.PublicKeyCredential.isExternalCTAP2SecurityKeySupported)return window.PublicKeyCredential.isExternalCTAP2SecurityKeySupported();return this.supported()};$this.isConditionalMediationAvailable=function(){if(window.PublicKeyCredential&&window.PublicKeyCredential.isConditionalMediationAvailable&&window.isSecureContext)return window.PublicKeyCredential.isConditionalMediationAvailable();return new Promise(function(_a,
r){r()})};$this.createAbortSignal=function(){if($this.abortController)$this.abortController.abort();$this.abortController=new AbortController;return $this.abortController.signal};var callCredentials=function(func){return function(){return func.apply(navigator.credentials,arguments)}};$this.create=function(){return callCredentials(navigator.credentials.create)};$this.get=function(){return callCredentials(navigator.credentials.get)};return $this});clearreportsApp.factory("PasskeysAuthentication",["$rootScope",
"dataservice","WebauthnSupport","errorservice","$timeout",function($rootScope,dataservice,WebauthnSupport,errorservice,$timeout){var $this=this;const nonRecoverableErrors=["SecurityError","NotSupportedError","ConstraintError","NotReadableError","NotAllowedError"];const recoverableErrors=["InvalidStateError","TimeoutError","OperationError","EncodingError","DataError"];const ignoredErrors=["AbortError"];var createRequest=function(command,data){return new Promise(function(resolve,reject){dataservice.execute(command,
{url:$rootScope.rootPath+"login/passkeys?",data:JSON.stringify(data),handleSuccess:resolve,handlError:reject})})};var requestChallenge=function(isSignUp,userName){errorservice.clearErrorContent("#loginFormError");return createRequest("passkeys.credentials",{isSignUp:isSignUp,userName:userName})};var verifyAuthenticationOptions=function(requestPage){return function(credentials){credentials=credentials||{};var response=credentials.response||{};var requestData={rawId:arrayBufferToBase64(credentials.rawId),
clientDataJSON:arrayBufferToBase64(response.clientDataJSON)};response.attestationObject&&(requestData.attestationObject=arrayBufferToBase64(response.attestationObject));response.authenticatorData&&(requestData.authenticatorData=arrayBufferToBase64(response.authenticatorData));response.signature&&(requestData.signature=arrayBufferToBase64(response.signature));response.userHandle&&(requestData.userHandle=arrayBufferToBase64(response.userHandle));return createRequest("passkeys.verify\x26RequestPage\x3d"+
(requestPage||$rootScope.rootPath),requestData)}};var encode=function(input){return arrayToArrayBufferView(toUTF8Array(input))};var transformSignUpData=function(rawData){rawData.challenge=encode(rawData.challenge);rawData.user.id=encode(rawData.user.id);rawData.excludeCredentials&&$(rawData.excludeCredentials).each(function(cred){cred.id=encode(cred.id)});rawData.authenticatorSelection={residentKey:"required",userVerification:"required"};var challenge={publicKey:rawData,signal:WebauthnSupport.createAbortSignal()};
return challenge};var transformLoginData=function(useConditionalMediation){return function(rawData){if(!rawData.challenge)return null;rawData.challenge=encode(rawData.challenge);rawData.userVerification="required";var challenge={publicKey:rawData,signal:WebauthnSupport.createAbortSignal()};if(useConditionalMediation)challenge.mediation="conditional";return challenge}};$this.checkForErrors=function(response){if(!response||!response.error)return response;throw new Error(response.error);};$this.handleErrors=
function(error){var message=error.message||error;if(ignoredErrors.includes(error.name))return;if(recoverableErrors.includes(error.name))message=$rootScope.getMsg("passkeys.failed")+" "+message;if(nonRecoverableErrors.includes(error.name))message=$rootScope.getMsg("passkeys.notSupported")+" "+message;else if($this.conditionalMediationStarted)$this.startConditionalMediation();errorservice.showerrorcontent(message,"#loginFormError");throw error;};$this.register=function(requestPage,userName){return requestChallenge(true,
userName).then(transformSignUpData).then(WebauthnSupport.create()).then(verifyAuthenticationOptions(requestPage)).then($this.checkForErrors)};$this.login=function(requestPage,useConditionalMediation){return requestChallenge().then(transformLoginData(useConditionalMediation)).then(WebauthnSupport.get()).then(verifyAuthenticationOptions(requestPage)).then($this.checkForErrors)};$this.conditionalMediationStarted=false;$this.startConditionalMediation=function(suppressErrors){$this.conditionalMediationStarted=
true;$this.login($this.getRequestPage(),true).then($this.redirect).catch(suppressErrors?$.noop:$this.handleErrors)};$this.getRequestPage=function(){var query=(window.location.search||"?").substring(1);var vars=query.split("\x26");for(var i=0;i<vars.length;i++){var pair=vars[i].split("\x3d");if(pair[0].toLowerCase()=="requestpage")return decodeURIComponent(pair[1])}return window.location.href};$this.redirect=function(response){$timeout(function(){if(response.redirectURL)window.location.href=response.redirectURL;
else window.location.reload(true)})};return $this}])})();