/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.passkeys.server.authentication;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.RemoteLoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.authentication.passkeys.server.authentication.PasskeyData;
import com.inet.authentication.passkeys.server.handler.PasskeyGetCredentialsRequest;
import com.inet.authentication.passkeys.server.handler.PasskeyGetCredentialsResponse;
import com.inet.authentication.passkeys.server.handler.PasskeySignupCredentialsResponse;
import com.inet.authentication.passkeys.server.handler.PasskeyVerifyCredentialsRequest;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginDispatcherServlet;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.json.EncodedReader;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.remote.gui.modules.login.LoginServlet;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.authenticator.AuthenticatorImpl;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.server.ServerProperty;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class b
extends RemoteLoginProcessor {
    private static WebAuthnManager b;
    private String c;
    private LoginSettings d;

    protected b(AuthenticationDescription authenticationDescription) {
        super(authenticationDescription);
        ForkJoinPool.commonPool().execute(() -> com.inet.authentication.passkeys.server.authentication.b.a());
    }

    public void requestLoginData(HttpServletRequest request, HttpServletResponse response) {
        if (LoginManager.isApplicationRequest((HttpServletRequest)request)) {
            if (!this.transferClientLoginData(request, response)) {
                return;
            }
            response.setStatus(401);
        }
        try {
            PluginDispatcherServlet.forward((String)"/login/passkeys/ui", (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (ServletException | IOException throwable) {
            LOGGER.error(throwable);
        }
    }

    public boolean transferClientLoginData(HttpServletRequest request, HttpServletResponse response) {
        boolean bl = request.getParameter("passkeys.credentials") != null;
        boolean bl2 = request.getParameter("passkeys.verify") != null;
        Object object = null;
        if (bl) {
            object = this.a(request, response);
        } else if (bl2) {
            object = this.b(request, response);
        }
        if (object != null) {
            try {
                response.setStatus(200);
                new Json().toJson(object, (OutputStream)response.getOutputStream());
                return false;
            }
            catch (IOException iOException) {
                LOGGER.error((Throwable)iOException);
                throw new ClientMessageException(iOException.getMessage());
            }
        }
        return true;
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="We're storing the sent user name temporarily")
    private Object a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.setContentType("application/binary-json");
            EncodedReader encodedReader = new EncodedReader((InputStream)httpServletRequest.getInputStream());
            PasskeyGetCredentialsRequest passkeyGetCredentialsRequest = (PasskeyGetCredentialsRequest)new Json().fromJson((Reader)encodedReader, PasskeyGetCredentialsRequest.class);
            if (passkeyGetCredentialsRequest == null) {
                return null;
            }
            if (passkeyGetCredentialsRequest.getIsSignup()) {
                String string = passkeyGetCredentialsRequest.getUserName();
                httpServletRequest.getSession().setAttribute("passkeys.username", (Object)string);
                return PasskeySignupCredentialsResponse.from(httpServletRequest, string);
            }
            return PasskeyGetCredentialsResponse.forLogin(httpServletRequest);
        }
        catch (Throwable throwable) {
            LOGGER.error(throwable);
            throw new ClientMessageException(throwable.getMessage());
        }
    }

    private Object b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            Object object3;
            UserAccount userAccount;
            HashMap<String, String> hashMap;
            Object object2;
            boolean bl;
            httpServletResponse.setContentType("application/binary-json");
            EncodedReader encodedReader = new EncodedReader((InputStream)httpServletRequest.getInputStream());
            PasskeyVerifyCredentialsRequest passkeyVerifyCredentialsRequest = (PasskeyVerifyCredentialsRequest)new Json().fromJson((Reader)encodedReader, PasskeyVerifyCredentialsRequest.class);
            if (passkeyVerifyCredentialsRequest == null) {
                return null;
            }
            String string = passkeyVerifyCredentialsRequest.getRawId();
            String string2 = passkeyVerifyCredentialsRequest.getAttestationObject();
            String string3 = passkeyVerifyCredentialsRequest.getClientDataJSON();
            boolean bl2 = bl = string2 != null && string3 != null;
            if (bl) {
                object2 = new Json().toJson((Object)PasskeyData.from(string3, string2));
                hashMap = (String)httpServletRequest.getSession().getAttribute("passkeys.username");
                this.d = new LoginSettings("passkeys", string, (String)object2, hashMap);
                userAccount = this.getOrCreateUserAccount(string);
            } else {
                object2 = UserManager.getInstance();
                userAccount = object2.findActiveUserAccount("passkeys", string);
                if (userAccount != null) {
                    for (Object object3 : userAccount.getLoginSettings()) {
                        if (!this.isSameAccount(string, null, (LoginSettings)object3)) continue;
                        if (this.a((LoginSettings)object3, passkeyVerifyCredentialsRequest)) break;
                        userAccount = null;
                        break;
                    }
                }
            }
            object2 = ServletUtils.getRequestPage((HttpServletRequest)httpServletRequest);
            hashMap = new HashMap<String, String>();
            if (userAccount != null) {
                this.c = string;
            } else {
                if (StringFunctions.isEmpty((String)object2)) {
                    object2 = "";
                }
                object2 = String.valueOf(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)httpServletRequest)) + httpServletRequest.getContextPath() + "/login?RequestPage=" + EncodingFunctions.encodeUrlParameter((String)object2);
                if (!bl) {
                    hashMap.put("error", LoginServlet.MSG.getMsg("login.invalidCredentials", new Object[0]));
                }
            }
            object3 = ServletUtils.createRedirectURL((HttpServletRequest)httpServletRequest, (String)object2, null);
            hashMap.put("redirectURL", StringFunctions.isEmpty((String)object3) ? "" : object3);
            return hashMap;
        }
        catch (Throwable throwable) {
            LOGGER.error(throwable);
            throw new ClientMessageException(throwable.getMessage());
        }
    }

    @Nonnull
    private static WebAuthnManager a() {
        WebAuthnManager webAuthnManager = b;
        if (webAuthnManager == null) {
            b = webAuthnManager = WebAuthnManager.createNonStrictWebAuthnManager();
        }
        return webAuthnManager;
    }

    private boolean a(LoginSettings loginSettings, PasskeyVerifyCredentialsRequest passkeyVerifyCredentialsRequest) {
        try {
            PasskeyData passkeyData = (PasskeyData)new Json().fromJson(loginSettings.getAdditionalData(), PasskeyData.class);
            byte[] byArray = com.inet.authentication.passkeys.server.authentication.b.a(passkeyData.getAttestationObject());
            byte[] byArray2 = com.inet.authentication.passkeys.server.authentication.b.a(passkeyData.getClientDataJSON());
            RegistrationRequest registrationRequest = new RegistrationRequest(byArray, byArray2, null, null);
            WebAuthnManager webAuthnManager = com.inet.authentication.passkeys.server.authentication.b.a();
            RegistrationData registrationData = webAuthnManager.parse(registrationRequest);
            AuthenticatorImpl authenticatorImpl = new AuthenticatorImpl(registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData(), registrationData.getAttestationObject().getAttestationStatement(), registrationData.getAttestationObject().getAuthenticatorData().getSignCount());
            byte[] byArray3 = com.inet.authentication.passkeys.server.authentication.b.a(loginSettings.getLoginID());
            byte[] byArray4 = com.inet.authentication.passkeys.server.authentication.b.a(passkeyVerifyCredentialsRequest.getUserHandle());
            byArray2 = com.inet.authentication.passkeys.server.authentication.b.a(passkeyVerifyCredentialsRequest.getClientDataJSON());
            byte[] byArray5 = com.inet.authentication.passkeys.server.authentication.b.a(passkeyVerifyCredentialsRequest.getAuthenticatorData());
            byte[] byArray6 = com.inet.authentication.passkeys.server.authentication.b.a(passkeyVerifyCredentialsRequest.getSignature());
            AuthenticationRequest authenticationRequest = new AuthenticationRequest(byArray3, byArray4, byArray5, byArray2, null, byArray6);
            AuthenticationData authenticationData = webAuthnManager.parse(authenticationRequest);
            Origin origin = new Origin(ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)SessionStore.getHttpServletRequest()).toString());
            String string = origin.getHost();
            Challenge challenge = () -> ((String)SessionStore.getHttpSession().getAttribute("passkeys.challenge")).getBytes();
            ServerProperty serverProperty = new ServerProperty(origin, string, challenge, null);
            List<byte[]> list = Collections.singletonList(byArray3);
            AuthenticationParameters authenticationParameters = new AuthenticationParameters(serverProperty, (Authenticator)authenticatorImpl, list, false, true);
            webAuthnManager.validate(authenticationData, authenticationParameters);
            this.c = loginSettings.getLoginID();
            return true;
        }
        catch (Throwable throwable) {
            LOGGER.error(throwable);
            return false;
        }
    }

    private static byte[] a(@Nullable String string) {
        return string != null ? Base64.getDecoder().decode(string) : null;
    }

    @Nonnull
    public String getLoginSource() {
        return "passkeys";
    }

    @Nullable
    public String getLoginID() {
        return this.c;
    }

    public boolean supportsRoles() {
        return false;
    }

    public boolean isWebUserInRole(String role) {
        return false;
    }

    @Nonnull
    public LoginSettings createLoginSettings(String loginID) {
        return this.d;
    }
}

