/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.authentication.database;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.base.BasicLoginProcessor;
import com.inet.cache.MemoryStoreMap;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.permissions.AccessDeniedException;
import com.inet.report.authentication.database.c;
import com.inet.report.authentication.database.d;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

class b
extends BasicLoginProcessor {
    private static final Map<String, d> b;
    private c c;
    private String d;
    private String e;

    b(AuthenticationDescription authenticationDescription, String string) {
        super(authenticationDescription);
        this.d = string;
    }

    @Nonnull
    public String getLoginSource() {
        return "system";
    }

    public String getLoginID() {
        if (this.c != null) {
            try {
                return this.c.getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
                LOGGER.error((Throwable)sQLException);
            }
        }
        return null;
    }

    public boolean supportsRoles() {
        return this.c != null && this.a();
    }

    public boolean isWebUserInRole(String role) {
        if (this.c == null || !this.a()) {
            return false;
        }
        try {
            PreparedStatement preparedStatement = this.c.prepareStatement("SELECT IS_MEMBER(?)");
            preparedStatement.setString(1, role);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            boolean bl = resultSet.getBoolean(1);
            resultSet.close();
            preparedStatement.close();
            return bl;
        }
        catch (SQLException sQLException) {
            LOGGER.error((Throwable)sQLException);
            return false;
        }
    }

    public void requestLoginData(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (this.c != null) {
            this.c.finalize();
            this.c = null;
        }
        if (this.a()) {
            httpResponse.addHeader("WWW-Authenticate", "NTLM");
        }
        super.requestLoginData(httpRequest, httpResponse);
        if (this.e != null) {
            try {
                httpResponse.getOutputStream().write(this.e.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {
                LOGGER.debug((Object)iOException);
            }
        }
    }

    public boolean transferClientLoginData(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        d d2;
        String string = httpRequest.getHeader("Authorization");
        if (string == null) {
            return true;
        }
        if (string.startsWith("Basic ")) {
            return super.transferClientLoginData(httpRequest, httpResponse);
        }
        if (!string.startsWith("NTLM") || !this.a()) {
            this.requestLoginData(httpRequest, httpResponse);
            return false;
        }
        byte[] byArray = Base64.getDecoder().decode(string.substring(4).trim());
        String string2 = httpRequest.getRemoteAddr() + ":" + httpRequest.getRemotePort();
        if (LOGGER.isDebug()) {
            LOGGER.debug((Object)("Socket key: " + string2));
        }
        if ((d2 = b.get(string2)) == null) {
            d2 = new d(this.d, byArray);
            b.put(string2, d2);
            d2.start();
            byArray = d2.d();
            if (byArray == null) {
                b.remove(string2);
                this.requestLoginData(httpRequest, httpResponse);
                return false;
            }
            httpResponse.addHeader("WWW-Authenticate", "NTLM " + Base64.getEncoder().encodeToString(byArray));
            super.requestLoginData(httpRequest, httpResponse);
            return false;
        }
        Connection connection = d2.a(byArray);
        b.remove(string2);
        if (connection != null) {
            this.c = new c(connection);
            return true;
        }
        this.e = d2.e();
        this.requestLoginData(httpRequest, httpResponse);
        return false;
    }

    protected boolean transferClientLoginData(@Nonnull String username, @Nonnull String password, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws Exception {
        try {
            this.c = new c(DriverManager.getConnection(this.d, username, password));
        }
        catch (SQLException sQLException) {
            if (LOGGER.isDebug()) {
                LOGGER.debug((Object)sQLException);
            }
            this.requestLoginData(httpRequest, httpResponse);
            return false;
        }
        return true;
    }

    boolean a() {
        return this.d.startsWith("jdbc:inetdae");
    }

    Connection b() throws AccessDeniedException {
        if (this.c == null) {
            throw new AccessDeniedException((ErrorCode)BaseErrorCode.UserNotLoggedIn, (Object[])null);
        }
        return this.c;
    }

    static {
        MemoryStoreMap memoryStoreMap = new MemoryStoreMap();
        memoryStoreMap.setTimeout(60, false);
        b = new HashMap<String, d>();
    }
}

