/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.extensions;

import com.inet.helpdesk.plugins.attachments.server.AutoTextDAO;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCareExtension;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class AutoTextAttachmentDataCareExtension
implements AttachmentDataCareExtension {
    @Override
    public AttachmentOwnerType getAttachmentType() {
        return AttachmentOwnerType.AutoTextAttachment;
    }

    @Override
    public List<Integer> findUnrelatedAttachments(Connection connection) throws Exception {
        int attId;
        ResultSet rs;
        ArrayList<Integer> attachmentIds = new ArrayList<Integer>();
        String sql = "SELECT attachmentId FROM tblAttachments WHERE type = ? AND isEmbedded = 0 AND ownerId NOT IN (SELECT AutoTextID FROM tblAutoTexts)";
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setInt(1, AttachmentOwnerType.AutoTextAttachment.getId());
            rs = pstm.executeQuery();
            try {
                while (rs.next()) {
                    attId = rs.getInt(1);
                    attachmentIds.add(attId);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        sql = "SELECT attachmentId, ownerId, secondId, thirdId, fileName FROM tblAttachments WHERE type = ? AND isEmbedded = 1";
        pstm = connection.prepareStatement(sql);
        try {
            pstm.setInt(1, AttachmentOwnerType.AutoTextAttachment.getId());
            rs = pstm.executeQuery();
            try {
                while (rs.next()) {
                    String fileName;
                    Integer additionalId;
                    Integer stepId;
                    attId = rs.getInt(1);
                    Integer ownerId = rs.getInt(2);
                    AttachmentKey key = new AttachmentKey(AttachmentOwnerType.AutoTextAttachment, ownerId, stepId = Integer.valueOf(rs.getInt(3)), additionalId = Integer.valueOf(rs.getInt(4)), fileName = new String(rs.getBytes(5), "UTF-8"));
                    String attachmentPath = AttachmentFilePathBuilder.getRestfulPathForClient(key);
                    int referenceCount = new AutoTextDAO().getNumberOfAutoTextEntriesWhichReferenceAttachmentUsingGivenPath(attachmentPath);
                    if (referenceCount != 0) continue;
                    attachmentIds.add(attId);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (pstm != null) {
                pstm.close();
            }
        }
        return attachmentIds;
    }
}

