/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.extensions;

import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.utils.StringConcatenator;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddOrDeleteAttachmentActionExtensionFactory;
import com.inet.helpdesk.plugins.attachments.server.extensions.TicketAttachmentAdder;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.shared.http.upload.AttachmentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AddAttachmentsTicketActionExtension
implements TicketActionExtension,
CreateTicketExtension {
    private TicketAttachmentAdder adder = new TicketAttachmentAdder();
    private final List<LargeContent> attachments;

    public AddAttachmentsTicketActionExtension(@Nullable AddAttachmentsExtensionData extensionData) {
        this.attachments = extensionData == null ? Collections.emptyList() : extensionData.getAttachments();
    }

    public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
        this.addAttachmentsToStep(ticket, reaStep, action);
    }

    public void beforeCreate(OperationChangedTicket newTicket, OperationNewReaStep anfrageStep, TicketSubOperations operations) {
        this.addAttachmentsToStep(newTicket, anfrageStep, null);
    }

    private void addAttachmentsToStep(OperationChangedTicket ticket, OperationNewReaStep reaStep, @Nullable ActionVO action) {
        String updatedStepContent;
        int ticketID = ticket.getTicketId();
        int reaStepID = reaStep.getReaStepId();
        MutableReaStepText text = reaStep.getText();
        boolean addedNonEmbeddedAtts = false;
        if (!this.attachments.isEmpty()) {
            ArrayList<String> addedAttachmentFileNames = new ArrayList<String>();
            String resultingStepContent = this.adder.addAttachmentsToTicket(ticketID, reaStepID, text.getText(), this.attachments, addedAttachmentFileNames);
            if (resultingStepContent != null) {
                text.setText(resultingStepContent);
            }
            if (this.attachments.stream().anyMatch(lc -> lc.getContentType() == AttachmentType.Attachment)) {
                addedNonEmbeddedAtts = true;
            }
            if (action != null && action.getId() == -21) {
                String allAttFileNames;
                String stepDesc = allAttFileNames = addedAttachmentFileNames.stream().collect(Collectors.joining(", "));
                int maxDescLength = 255;
                if (stepDesc.length() > maxDescLength) {
                    stepDesc = StringConcatenator.concatAndShortenIfNeeded(addedAttachmentFileNames, (int)maxDescLength);
                    text.setText(allAttFileNames);
                }
                reaStep.getFields().put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)stepDesc);
            }
        }
        if (!text.getText().isEmpty() && text.hasHtmlContent() && (updatedStepContent = this.adder.convertExternalImagesToAttachments(ticketID, reaStepID, text.getText())) != null) {
            text.setText(updatedStepContent);
        }
        if (addedNonEmbeddedAtts) {
            AddOrDeleteAttachmentActionExtensionFactory.updateAttachmentFlagForBundle(true, ticket);
        }
    }
}

