/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.FilterableAttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.FilterableAttachments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AttachmentRecognizer {
    public FilterableAttachments createFilterableAttachmentsFrom(Map<AttachmentRow, AttachmentFileRow> attachments) {
        if (attachments == null) {
            throw new IllegalArgumentException("given map must not be null");
        }
        ArrayList<FilterableAttachmentDescription> filterableAttachments = new ArrayList<FilterableAttachmentDescription>();
        HashSet<String> setOfChecksums = new HashSet<String>();
        for (Map.Entry<AttachmentRow, AttachmentFileRow> entry : this.asOrderedList(attachments)) {
            AttachmentRow key = entry.getKey();
            AttachmentFileRow value = entry.getValue();
            boolean isUnique = !setOfChecksums.contains(value.getChecksum());
            AttachmentDescription description = AttachmentService.createDescriptionFrom(key, value);
            filterableAttachments.add(new FilterableAttachmentDescription(description, isUnique, key.isEmbedded()));
            setOfChecksums.add(value.getChecksum());
        }
        return new FilterableAttachments(filterableAttachments);
    }

    private List<Map.Entry<AttachmentRow, AttachmentFileRow>> asOrderedList(Map<AttachmentRow, AttachmentFileRow> attachments) {
        ArrayList<Map.Entry<AttachmentRow, AttachmentFileRow>> list = new ArrayList<Map.Entry<AttachmentRow, AttachmentFileRow>>(attachments.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<AttachmentRow, AttachmentFileRow>>(){

            @Override
            public int compare(Map.Entry<AttachmentRow, AttachmentFileRow> firstAttachment, Map.Entry<AttachmentRow, AttachmentFileRow> secondAttachment) {
                boolean isFirstAttachmentEmbedded = firstAttachment.getKey().isEmbedded();
                boolean isSecondAttachmentEmbedded = secondAttachment.getKey().isEmbedded();
                if (isFirstAttachmentEmbedded && !isSecondAttachmentEmbedded) {
                    return 1;
                }
                if (!isFirstAttachmentEmbedded && isSecondAttachmentEmbedded) {
                    return -1;
                }
                int resultOfLastModifiedComparison = Long.compare(firstAttachment.getKey().getLastModified(), secondAttachment.getKey().getLastModified());
                if (resultOfLastModifiedComparison != 0) {
                    return resultOfLastModifiedComparison;
                }
                return firstAttachment.getKey().getFileName().compareTo(secondAttachment.getKey().getFileName());
            }
        });
        return list;
    }
}

