/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.webapi;

import com.inet.annotations.InternalApi;
import com.inet.http.PluginDispatcherServlet;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nullable;

@Tag(name="Attachments", description="Operations for managing HelpDesk attachments")
@InternalApi
public class AttachmentsInfoHandler
extends RequestHandler.WithCurrentPathToken<Void, Void, String> {
    public AttachmentsInfoHandler() {
        super(new String[]{"attachment"});
    }

    public String typeFor(String token) {
        return token;
    }

    public String getHelpPageKey() {
        return "webapi.attachments.attachment";
    }

    @Operation(summary="Access HelpDesk attachment", description="Forwards requests to the attachment servlet to handle attachment operations", responses={@ApiResponse(responseCode="200", description="Attachment operation completed successfully"), @ApiResponse(responseCode="400", description="Invalid request or attachment path"), @ApiResponse(responseCode="404", description="Attachment not found")})
    public Void handle(HttpServletRequest request, HttpServletResponse response, @Nullable Void inputObject, @Nullable String requestPath, boolean previewModeEnabled) throws IOException {
        try {
            requestPath = request.getPathInfo();
            PluginDispatcherServlet.forward((String)requestPath, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (ServletException | IOException e) {
            throw new IllegalArgumentException(e);
        }
        return null;
    }
}

