/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.protocol;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.data.FileContainer;
import com.inet.helpdesk.core.data.TempDirectory;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.http.utils.MimeTypes;
import com.inet.persistence.PersistenceEntry;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.sql.SQLException;

public class AttachmentURLConnection
extends URLConnection {
    private final URL url;
    private final FileContainer fileContainer;
    private final AttachmentDAO attachmentDAO;
    private InputStream input;
    private IOException exception;
    private String contentType;

    protected AttachmentURLConnection(URL url, AttachmentDAO attachmentDAO) {
        super(url);
        this.url = url;
        this.attachmentDAO = attachmentDAO;
        FileContainer fileContainer = this.extractFileFromUrl();
        this.contentType = MimeTypes.getMimeType((String)url.getFile());
        this.fileContainer = fileContainer;
    }

    private FileContainer extractFileFromUrl() {
        String path = this.url.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)e);
        }
        try {
            AttachmentFileRow attachmentFileRow;
            AttachmentKey key = AttachmentFilePathBuilder.isRestfulPath(path) ? AttachmentFilePathBuilder.convertRestfulPathToKey(path) : AttachmentFilePathBuilder.convertOldPathToKey(path, AttachmentOwnerType.TicketAttachment);
            UserAccount currentUser = UserManager.getInstance().getCurrentUserAccount();
            key.getType().checkPermission(currentUser, key);
            try {
                attachmentFileRow = this.attachmentDAO.getAttachmentFile(key);
            }
            catch (SQLException e) {
                AttachmentsServerPlugin.LOGGER.error((Throwable)e);
                this.exception = new IOException(e);
                return null;
            }
            if (attachmentFileRow == null) {
                AttachmentsServerPlugin.LOGGER.warn((Object)("Attachment not found for path " + path));
                this.exception = new IOException("Attachment not found for path " + path);
                return null;
            }
            String realFilePath = attachmentFileRow.getFilePath();
            PersistenceEntry file = AppDataLocation.getAttachmentFile((String)realFilePath);
            return new FileContainer(file);
        }
        catch (IllegalArgumentException exc) {
            String tempMimeAttDirPrefix = "Attachments_Temp";
            if (path.startsWith(tempMimeAttDirPrefix)) {
                if ((path = path.substring(tempMimeAttDirPrefix.length())).startsWith(File.separator) || path.startsWith("/")) {
                    path = path.substring(1);
                }
                File file = TempDirectory.ATTACHMENTS_TEMP.resolve(path).toFile();
                try {
                    File attachmentTempDir = TempDirectory.ATTACHMENTS_TEMP.toFile().getCanonicalFile();
                    if (!file.getCanonicalFile().toPath().startsWith(attachmentTempDir.toPath())) {
                        this.exception = new IOException("not allowed path " + path);
                        return null;
                    }
                }
                catch (IOException e) {
                    this.exception = e;
                    return null;
                }
                return new FileContainer(file.getName(), path, () -> new FileInputStream(file));
            }
            this.exception = new IOException("no file at path " + path);
            return null;
        }
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        this.input = this.fileContainer.getInputStream();
        if (this.input == null) {
            this.exception = new IOException("no file at path " + this.fileContainer.getPath());
            throw this.exception;
        }
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.input;
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ("content-type".equalsIgnoreCase(name)) {
            return this.contentType;
        }
        return super.getHeaderField(name);
    }
}

