/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.calendar;

import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.calendar.Content;
import com.inet.helpdesk.plugins.attachments.server.calendar.TimeDescription;
import com.inet.helpdesk.plugins.attachments.shared.CalendarDateContent;
import com.inet.persistence.PersistenceEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class CalendarParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarDateContent parse(PersistenceEntry file) {
        InputStream is;
        block23: {
            CalendarDateContent calendarDateContent;
            is = file.getInputStream();
            InputStreamReader isr = null;
            try {
                String line;
                isr = new InputStreamReader(is, "UTF8");
                BufferedReader bfReader = new BufferedReader(isr);
                Content main = null;
                Content current = null;
                while ((line = bfReader.readLine()) != null) {
                    if (main != null && current == null) {
                        AttachmentsServerPlugin.LOGGER.error((Object)("Unreferenced line  -" + line + "-"));
                        continue;
                    }
                    if (line.startsWith("BEGIN:")) {
                        current = new Content(line.substring(6), current);
                        if (main != null) continue;
                        main = current;
                        continue;
                    }
                    if (line.startsWith("END:")) {
                        String name = line.substring(4);
                        if (name.equals(current.getName())) {
                            current = current.getParent();
                            continue;
                        }
                        AttachmentsServerPlugin.LOGGER.error((Object)("Unreferenced end  " + line));
                        continue;
                    }
                    current.appendLine(line);
                }
                main.refactor();
                String[] typeId = main.get("VCALENDAR", "PRODID");
                if (typeId == null || typeId.length != 2) {
                    throw new IllegalArgumentException("No format information!");
                }
                boolean isMsCalendarFormat = typeId[1].startsWith("Microsoft Exchange Server");
                if (isMsCalendarFormat) {
                    CalendarDateContent calendarDateContent2 = CalendarParser.handleCalendarFile(main);
                    return calendarDateContent2;
                }
                calendarDateContent = CalendarParser.handleIcsFile(main);
            }
            catch (IOException ex) {
                AttachmentsServerPlugin.LOGGER.error((Throwable)ex);
                break block23;
            }
            finally {
                try {
                    isr.close();
                }
                catch (Throwable throwable) {}
            }
            return calendarDateContent;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static CalendarDateContent handleCalendarFile(Content main) {
        String definitionTimezone = main.get("VTIMEZONE", "TZID")[1];
        String[] standard = new String[]{main.get("STANDARD", "TZOFFSETFROM")[1], main.get("STANDARD", "TZOFFSETTO")[1], main.get("STANDARD", "DTSTART")[1], main.get("STANDARD", "RRULE")[1]};
        String[] daylight = new String[]{main.get("DAYLIGHT", "TZOFFSETFROM")[1], main.get("DAYLIGHT", "TZOFFSETTO")[1], main.get("DAYLIGHT", "DTSTART")[1], main.get("DAYLIGHT", "RRULE")[1]};
        TimeDescription eventStart = CalendarParser.getTimeDescription(main.get("VEVENT", "DTSTART"), definitionTimezone);
        TimeDescription eventEnd = CalendarParser.getTimeDescription(main.get("VEVENT", "DTEND"), definitionTimezone);
        TimeDescription eventCreated = CalendarParser.getTimeDescription(main.get("VEVENT", "DTSTAMP"), definitionTimezone);
        CalendarDateContent cdc = new CalendarDateContent();
        CalendarParser.handleOrganizer(main.get("VEVENT", "ORGANIZER"), cdc);
        cdc.setAttendees(CalendarParser.getAttendees(main));
        cdc.setCreationTime(CalendarParser.normilizeToUTC(eventCreated, definitionTimezone, standard, daylight));
        cdc.setEventStartTime(CalendarParser.normilizeToUTC(eventStart, definitionTimezone, standard, daylight));
        cdc.setEventEndTime(CalendarParser.normilizeToUTC(eventEnd, definitionTimezone, standard, daylight));
        cdc.setDescription(main.get("VEVENT", "DESCRIPTION")[1]);
        cdc.setSummary(main.get("VEVENT", "SUMMARY")[1]);
        cdc.setPriority(Integer.parseInt(main.get("VEVENT", "PRIORITY")[1]));
        return cdc;
    }

    private static CalendarDateContent handleIcsFile(Content main) {
        String definitionTimezone = main.get("VTIMEZONE", "TZID")[1];
        CalendarDateContent cdc = new CalendarDateContent();
        CalendarParser.handleOrganizer(main.get("VEVENT", "ORGANIZER"), cdc);
        cdc.setAttendees(CalendarParser.getAttendees(main));
        cdc.setDescription(main.get("VEVENT", "DESCRIPTION")[1]);
        cdc.setSummary(main.get("VEVENT", "SUMMARY")[1]);
        TimeDescription eventStart = CalendarParser.getTimeDescription(main.get("VEVENT", "DTSTART"), definitionTimezone);
        TimeDescription eventEnd = CalendarParser.getTimeDescription(main.get("VEVENT", "DTEND"), definitionTimezone);
        TimeDescription eventCreated = CalendarParser.getTimeDescription(main.get("VEVENT", "DTSTAMP"), definitionTimezone);
        cdc.setCreationTime(CalendarParser.getTimeIcs(eventCreated));
        cdc.setEventStartTime(CalendarParser.getTimeIcs(eventStart));
        cdc.setEventEndTime(CalendarParser.getTimeIcs(eventEnd));
        return cdc;
    }

    private static long getTimeIcs(TimeDescription td) {
        String[] tzIds;
        TimeZone tZ = null;
        for (String tzId : tzIds = TimeZone.getAvailableIDs()) {
            if (!tzId.equals(td.getTimeZone())) continue;
            tZ = TimeZone.getTimeZone(tzId);
        }
        if (tZ == null) {
            tZ = TimeZone.getDefault();
        }
        Calendar cal = Calendar.getInstance(tZ);
        cal.set(td.getYear(), td.getMonth() - 1, td.getDay(), td.getHour(), td.getMinutes(), td.getSeconds());
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static String[][] getAttendees(Content main) {
        List<String> values = main.getValues("VEVENT");
        ArrayList<String[]> attendees = new ArrayList<String[]>();
        for (String value : values) {
            if (!value.startsWith("ATTENDEE;")) continue;
            String[] attendeeParts = value.split(";");
            String personalData = attendeeParts[attendeeParts.length - 1];
            String[] chunks = personalData.split(":");
            String mailaddress = chunks[chunks.length - 1];
            String name = CalendarParser.normalizeCN(chunks[0], "");
            attendees.add(new String[]{name, mailaddress});
        }
        return (String[][])attendees.toArray((T[])new String[attendees.size()][2]);
    }

    private static String normalizeCN(String conten, String defVal) {
        String retval = null;
        if (conten.startsWith("CN=")) {
            retval = conten.substring(3);
            if (retval.charAt(retval.length() - 1) == '\"') {
                retval = retval.substring(0, retval.length() - 1);
            }
            if (retval.charAt(0) == '\"') {
                retval = retval.substring(1);
            }
        } else {
            retval = defVal;
        }
        return retval;
    }

    private static void handleOrganizer(String[] data, CalendarDateContent cdc) {
        String mailAddress;
        String organizer = CalendarParser.normalizeCN(data[0], data[0]);
        String string = mailAddress = data[1].startsWith("mailto:") || data[1].startsWith("MAILTO:") ? data[1].substring(7) : data[1];
        if (organizer.startsWith("\"") && organizer.endsWith("\"")) {
            organizer = organizer.substring(1, organizer.length() - 1);
        }
        cdc.setOrganizer(organizer);
        cdc.setMailAddress(mailAddress);
    }

    private static long normilizeToUTC(TimeDescription td, String definitionTimezone, String[] standard, String[] daylight) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        Calendar cal = Calendar.getInstance(tz);
        if (!"UTC".equals(td.getTimeZone()) && definitionTimezone.equals(td.getTimeZone())) {
            if (standard[0].equals(standard[1])) {
                CalendarParser.shift(td, standard[0]);
            } else {
                TimeDescription standardBegin = CalendarParser.getReferenceDate(standard[3], standard[2], definitionTimezone, td, cal);
                TimeDescription daylightBegin = CalendarParser.getReferenceDate(daylight[3], daylight[2], definitionTimezone, td, cal);
                if (CalendarParser.smaller(daylightBegin, standardBegin)) {
                    if (CalendarParser.smaller(td, daylightBegin) || CalendarParser.smaller(standardBegin, td)) {
                        CalendarParser.shift(td, standard[1]);
                    } else {
                        CalendarParser.shift(td, daylight[1]);
                    }
                } else if (CalendarParser.smaller(td, daylightBegin) && CalendarParser.smaller(standardBegin, td)) {
                    CalendarParser.shift(td, standard[0]);
                } else {
                    CalendarParser.shift(td, daylight[0]);
                }
            }
            td.setTimeZone("UTC");
        }
        cal.set(td.getYear(), td.getMonth() - 1, td.getDay(), td.getHour(), td.getMinutes(), td.getSeconds());
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    private static void shift(TimeDescription td, String shiftValue) {
        int hours = Integer.parseInt(shiftValue.substring(0, 3)) * -1;
        int minutes = Integer.parseInt(shiftValue.substring(3));
        if (hours < 0) {
            td.setMinutes(td.getMinutes() - minutes);
        } else {
            td.setMinutes(td.getMinutes() + minutes);
        }
        td.setHour(td.getHour() + hours);
        if (td.getMinutes() < 0) {
            td.setHour(td.getHour() - 1);
            td.setMinutes(60 + td.getMinutes());
        } else if (td.getMinutes() > 59) {
            td.setHour(td.getHour() + 1);
            td.setMinutes(td.getMinutes() - 60);
        }
        if (td.getHour() < 0) {
            td.setDay(td.getDay() - 1);
            td.setHour(24 + td.getHour());
        } else if (td.getMinutes() > 23) {
            td.setDay(td.getDay() + 1);
            td.setHour(td.getHour() - 24);
        }
    }

    private static boolean smaller(TimeDescription compare, TimeDescription than) {
        if (compare.getMonth() != than.getMonth()) {
            return compare.getMonth() < than.getMonth();
        }
        if (compare.getDay() != than.getDay()) {
            return compare.getDay() < than.getDay();
        }
        if (compare.getHour() != than.getHour()) {
            return compare.getHour() < than.getHour();
        }
        if (compare.getMinutes() != than.getMinutes()) {
            return compare.getMinutes() < than.getMinutes();
        }
        if (compare.getSeconds() != than.getSeconds()) {
            return compare.getSeconds() < than.getSeconds();
        }
        return false;
    }

    private static TimeDescription getReferenceDate(String rule, String start, String definitionTimezone, TimeDescription td, Calendar cal) {
        TimeDescription ref = new TimeDescription(definitionTimezone);
        ref.setYear(td.getYear());
        String[] ruleParts = rule.split(";");
        String monthPart = ruleParts[3].split("=")[1];
        ref.setMonth(Integer.parseInt(monthPart));
        String dayPart = ruleParts[2].split("=")[1];
        int count = Integer.parseInt(dayPart.substring(0, dayPart.length() - 2));
        String reference = dayPart.substring(dayPart.length() - 2);
        cal.set(1, td.getYear());
        cal.set(2, ref.getMonth() - 1);
        cal.set(11, 12);
        if (count < 0) {
            cal.set(5, CalendarParser.getLastDay(ref));
            int div = cal.get(7) - 1;
            if (div != 0) {
                cal.add(5, -div);
            }
        } else {
            cal.set(5, 1);
            int div = 8 - cal.get(7);
            if (div != 7) {
                cal.add(5, div);
            }
            cal.add(5, (count - 1) * 7);
        }
        ref.setDay(cal.get(5));
        ref.setHour(Integer.parseInt(start.substring(9, 11)));
        ref.setMinutes(Integer.parseInt(start.substring(11, 13)));
        ref.setSeconds(Integer.parseInt(start.substring(13, 15)));
        return ref;
    }

    private static int getLastDay(TimeDescription ref) {
        switch (ref.getMonth()) {
            case 2: {
                if (ref.getYear() % 4 == 0) {
                    return 29;
                }
                return 28;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
        }
        return 30;
    }

    private static TimeDescription getTimeDescription(String[] baseValue, String vTimezone) {
        if (baseValue == null || baseValue[0] == null) {
            throw new IllegalArgumentException("No definition available!");
        }
        String zoneDef = baseValue[0];
        String timeZone = zoneDef.length() == 0 ? "UTC" : (zoneDef.startsWith("TZID=") ? zoneDef.substring(5) : (zoneDef.equals("VALUE=DATE") ? vTimezone : zoneDef));
        TimeDescription td = new TimeDescription(timeZone);
        String dateV = baseValue[1];
        td.setYear(Integer.parseInt(dateV.substring(0, 4)));
        td.setMonth(Integer.parseInt(dateV.substring(4, 6)));
        td.setDay(Integer.parseInt(dateV.substring(6, 8)));
        if (dateV.indexOf(84) > -1) {
            td.setHour(Integer.parseInt(dateV.substring(9, 11)));
            td.setMinutes(Integer.parseInt(dateV.substring(11, 13)));
            td.setSeconds(Integer.parseInt(dateV.substring(13, 15)));
        }
        return td;
    }
}

