/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.backup;

import com.inet.config.Configuration;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAOCacheCleaner;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ChecksumUtils;
import com.inet.helpdesk.plugins.attachments.server.backup.AttachmentBackupEntry;
import com.inet.helpdesk.plugins.attachments.server.backup.AttachmentRowForBackup;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.maintenance.api.MaintenanceHelper;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class AttachmentsBackupTask
implements BackupTask {
    private String detailDB;
    private String detailFiles;
    private AttachmentDAOCacheCleaner cacheCleaner;

    public AttachmentsBackupTask(AttachmentDAOCacheCleaner cacheCleaner) {
        if (cacheCleaner == null) {
            throw new IllegalArgumentException("cacheCleaner must not be null");
        }
        this.cacheCleaner = cacheCleaner;
    }

    public String getKey() {
        return "helpdesk.attachments";
    }

    public String getTitle() {
        return AttachmentsServerPlugin.MSG.getMsg("backup.task.attachments.title", new Object[0]);
    }

    public String getDescription() {
        return AttachmentsServerPlugin.MSG.getMsg("backup.task.attachments.description", new Object[0]);
    }

    public URL getIconURL() {
        return AttachmentsBackupTask.class.getResource("/com/inet/helpdesk/plugins/attachments/server/backup/attachments_32.png");
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, final BackupContentInformation contentInformation, final ProgressUpdater progressUpdater) throws Throwable {
        this.detailDB = null;
        this.detailFiles = null;
        progressUpdater.updateProgress(0);
        this.saveTableContent(taskPath, new FileProgress(){

            public void progressUpdate(int progress, int files) {
                AttachmentsBackupTask.this.detailDB = AttachmentsServerPlugin.MSG.getMsg("backup.task.attachments.taskdetail.db", new Object[]{files});
                AttachmentsBackupTask.this.setDetails(contentInformation);
                progressUpdater.updateProgress((int)Math.ceil((double)progress * 0.25));
            }
        });
        progressUpdater.updateProgress(25);
        BackupHelper helper = new BackupHelper();
        Persistence persistence = Persistence.getInstance();
        helper.createZipFromFolderContent(persistence.resolve("Attachments"), taskPath.resolve("attachments.zip"), new FileProgress(){

            public void progressUpdate(int progress, int files) {
                AttachmentsBackupTask.this.detailFiles = AttachmentsServerPlugin.MSG.getMsg("backup.task.attachments.taskdetail.files", new Object[]{files});
                AttachmentsBackupTask.this.setDetails(contentInformation);
                progressUpdater.updateProgress((int)Math.ceil((double)progress * 0.75) + 25);
            }
        });
        progressUpdater.updateProgress(100);
    }

    private void setDetails(BackupContentInformation contentInformation) {
        ArrayList<String> details = new ArrayList<String>();
        if (this.detailDB != null) {
            details.add(this.detailDB);
        }
        if (this.detailFiles != null) {
            details.add(this.detailFiles);
        }
        contentInformation.putTaskDetails(this.getKey(), details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTableContent(Path taskPath, FileProgress fileProgress) throws SQLException, IOException, FileNotFoundException {
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        AttachmentBackupEntry entry = new AttachmentBackupEntry();
        long refCount = 0L;
        long counter = 0L;
        try {
            connection = this.getConnection(this.getHDSEntry());
            statement = connection.createStatement();
            rs = statement.executeQuery("SELECT count(*) FROM tblAttachments INNER JOIN tblAttachmentFiles ON tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId");
            if (rs.next()) {
                refCount = rs.getLong(1);
            }
            rs.close();
            rs = statement.executeQuery("SELECT * FROM tblAttachments INNER JOIN tblAttachmentFiles ON tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId");
            while (rs.next()) {
                ArrayList<AttachmentRowForBackup> attRows;
                int type = rs.getInt("type");
                int ownerId = rs.getInt("ownerId");
                int secondId = rs.getInt("secondId");
                int thirdId = rs.getInt("thirdId");
                String fileName = new String(rs.getBytes("fileName"), StandardCharsets.UTF_8);
                String parentDirectoryPath = rs.getString("parentDirectoryPath");
                String checksum = ChecksumUtils.bytesToHexString(rs.getBytes("checksum"));
                boolean isEmbedded = rs.getBoolean("isEmbedded");
                long lastModified = rs.getLong("lastModified");
                long filelength = rs.getLong("filelength");
                AttachmentFileRow attFile = new AttachmentFileRow(checksum, parentDirectoryPath, filelength);
                AttachmentRowForBackup attRow = new AttachmentRowForBackup(type, ownerId, secondId, thirdId, fileName, checksum, filelength, isEmbedded, lastModified);
                int attIndex = entry.getFiles().indexOf(attFile);
                if (attIndex == -1) {
                    entry.getFiles().add(attFile);
                    attIndex = entry.getFiles().size() - 1;
                }
                if ((attRows = entry.getEntries().get(attIndex)) == null) {
                    attRows = new ArrayList();
                    entry.getEntries().put(attIndex, attRows);
                }
                attRows.add(attRow);
                ++counter;
                int progress = 1;
                if (refCount > 0L) {
                    progress = (int)Math.ceil((double)counter / (double)refCount * 100.0 * 0.8);
                }
                fileProgress.progressUpdate(progress, (int)counter);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        fileProgress.progressUpdate(80, (int)counter);
        try (FileOutputStream output = new FileOutputStream(taskPath.resolve("attachmenttables.data").toFile());){
            new Json().toJson((Object)entry, (OutputStream)output);
        }
        fileProgress.progressUpdate(1000, (int)counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTableContent(Path taskPath) throws SQLException, IOException, FileNotFoundException {
        block28: {
            String SQL_GET_ATTFILE = "SELECT * FROM tblAttachmentFiles WHERE checksum=? AND filelength=?";
            String SQL_GET_ATT = "SELECT * FROM tblAttachments WHERE type=? AND ownerId=? AND secondId=? AND thirdId=? AND fileName=?";
            Connection connection = null;
            PreparedStatement pstGetAttFile = null;
            Statement pstGetAtt = null;
            HashMap<Integer, Object> ticketAttNamesBeforeRestoreMap = new HashMap<Integer, Object>();
            try {
                connection = this.getConnection(this.getHDSEntry());
                pstGetAttFile = connection.prepareStatement(SQL_GET_ATTFILE, 1005, 1008);
                pstGetAtt = connection.prepareStatement(SQL_GET_ATT, 1005, 1008);
                AttachmentBackupEntry entry = null;
                Path attDataFile = taskPath.resolve("attachmenttables.data");
                if (!Files.isRegularFile(attDataFile, new LinkOption[0])) break block28;
                try (FileInputStream input = new FileInputStream(attDataFile.toFile());){
                    entry = (AttachmentBackupEntry)new Json().fromJson((InputStream)input, AttachmentBackupEntry.class);
                }
                for (int attIndex = 0; attIndex < entry.getFiles().size(); ++attIndex) {
                    AttachmentFileRow attFile = entry.getFiles().get(attIndex);
                    ArrayList<AttachmentRowForBackup> attRows = entry.getEntries().get(attIndex);
                    pstGetAttFile.setBytes(1, ChecksumUtils.hexStringToBytes(attFile.getChecksum()));
                    pstGetAttFile.setLong(2, attFile.getFileLength());
                    int attachmentFileId = -1;
                    try (ResultSet rs = pstGetAttFile.executeQuery();){
                        if (rs.next()) {
                            attachmentFileId = rs.getInt("attachmentFileId");
                        } else {
                            rs.moveToInsertRow();
                            rs.updateBytes("checksum", ChecksumUtils.hexStringToBytes(attFile.getChecksum()));
                            rs.updateLong("filelength", attFile.getFileLength());
                            rs.updateString("parentDirectoryPath", attFile.getDirectoryPath());
                            rs.insertRow();
                            rs.first();
                            attachmentFileId = rs.getInt("attachmentFileId");
                        }
                    }
                    for (AttachmentRowForBackup attRow : attRows) {
                        pstGetAtt.setInt(1, attRow.getType());
                        pstGetAtt.setInt(2, attRow.getOwnerId());
                        pstGetAtt.setInt(3, attRow.getStepId());
                        pstGetAtt.setInt(4, attRow.getAdditionalId());
                        pstGetAtt.setBytes(5, attRow.getFileName().getBytes(StandardCharsets.UTF_8));
                        ResultSet rs = pstGetAtt.executeQuery();
                        try {
                            if (rs.next()) continue;
                            if (AttachmentOwnerType.TicketAttachment.getId() == attRow.getType() && !ticketAttNamesBeforeRestoreMap.containsKey(attRow.getOwnerId())) {
                                Object attNamesBeforeRestore = AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.getValue(attRow.getOwnerId());
                                ticketAttNamesBeforeRestoreMap.put(attRow.getOwnerId(), attNamesBeforeRestore);
                            }
                            rs.moveToInsertRow();
                            rs.updateInt("type", attRow.getType());
                            rs.updateInt("ownerId", attRow.getOwnerId());
                            rs.updateInt("secondId", attRow.getStepId());
                            rs.updateInt("thirdId", attRow.getAdditionalId());
                            rs.updateBytes("fileName", attRow.getFileName().getBytes(StandardCharsets.UTF_8));
                            rs.updateBoolean("isEmbedded", attRow.isEmbedded());
                            rs.updateLong("lastModified", attRow.getLastModified());
                            rs.updateInt("attachmentFileId", attachmentFileId);
                            rs.insertRow();
                            this.cacheCleaner.clearAttachmentFileNames(AttachmentOwnerType.getTypeForId(attRow.getType()), attRow.getOwnerId());
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                }
            }
            finally {
                for (Map.Entry entry : ticketAttNamesBeforeRestoreMap.entrySet()) {
                    int ticketID = (Integer)entry.getKey();
                    List attNamesBefore = (List)entry.getValue();
                    Object attNamesAfter = AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.getValue(ticketID);
                    AttachmentsServerPlugin.SEARCH_TAG_ATTACHMENT_NAMES.valueChanged(ticketID, attNamesBefore, (List<String>)attNamesAfter);
                }
                if (pstGetAttFile != null) {
                    pstGetAttFile.close();
                }
                if (pstGetAtt != null) {
                    pstGetAtt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    private DatabaseConfigInfo getHDSEntry() {
        Configuration currentConfiguration = MaintenanceHelper.getCurrentConfiguration();
        String dbConfigValue = currentConfiguration.get(HDConfigKeys.DB_CONFIGS.getKey(), HDConfigKeys.DB_CONFIGS.getDefault());
        if (dbConfigValue == null || !dbConfigValue.startsWith("[")) {
            throw new ClientMessageException(AttachmentsServerPlugin.MSG.getMsg("backup.task.attachments.error.noconnections", new Object[0]));
        }
        DatabaseConfigInfoList databaseConfigInfoList = (DatabaseConfigInfoList)new Json().fromJson(dbConfigValue, DatabaseConfigInfoList.class);
        DatabaseConfigInfo hds = databaseConfigInfoList.get("HDS");
        if (hds == null) {
            throw new ClientMessageException(AttachmentsServerPlugin.MSG.getMsg("backup.task.attachments.error.nohdsconnection", new Object[0]));
        }
        return hds;
    }

    private Connection getConnection(DatabaseConfigInfo hds) throws SQLException {
        String driverClassName = hds.getDriverClassName();
        if (driverClassName != null) {
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return DriverManager.getConnection(hds.getUrl(), hds.getUser(), hds.getDecodedPassword());
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, final ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        this.restoreTableContent(taskPath);
        BackupHelper helper = new BackupHelper();
        Persistence persistence = Persistence.getInstance();
        Path source = taskPath.resolve("attachments.zip");
        PersistenceEntry target = persistence.resolve("Attachments");
        helper.extractZipIntoFolder(source, target, false, new FileProgress(){

            public void progressUpdate(int progress, int files) {
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("8.3")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }
}

