/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.classloader.translations.TranslationKey;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ticketlist.AttachmentData;
import com.inet.helpdesk.plugins.attachments.server.ticketlist.TicketAttachmentsContextDependentLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketFieldDefinitionAttachments
extends TicketFieldDefinition {
    public TicketFieldDefinitionAttachments(int prio) {
        super((TicketAttribute)Tickets.ATTRIBUTE_ATTACHMENTS, true, true, prio);
        this.setVisibility(TicketFieldDefinition.FIELD_VISIBILITY.ENDUSER);
    }

    public String getLabel() {
        return AttachmentsServerPlugin.MSG.getMsg("field.attachments", new Object[0]);
    }

    public String getDisplayValue(@Nonnull TicketVO ticket) {
        Boolean attribute = (Boolean)ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_ATTACHMENTS);
        if (attribute != null && attribute.booleanValue()) {
            List reaStepsForTicket = TicketManager.getReader().getReaStepsForTicket(ticket.getID(), BundleStepsFilter.WITH_BUNDLE_STEPS);
            Collection availableStepsIds = reaStepsForTicket.stream().map(ReaStepVO::getID).collect(Collectors.toSet());
            TicketAttachmentsContextDependentLoader.TicketAttachmentsContextDependentLoaderResult result = new TicketAttachmentsContextDependentLoader().load(ticket, availableStepsIds);
            ArrayList<AttachmentData> attachments = result.getAttachments();
            long attCount = attachments.stream().filter(ad -> !ad.isDuplicate() && !ad.isEmbedded()).count();
            return String.valueOf(attCount);
        }
        return null;
    }

    public String getValueAsStringForIcon(@Nonnull TicketVO ticket) {
        if (!ticket.hasAttachments()) {
            return null;
        }
        return String.valueOf(ticket.hasAttachments());
    }

    public URL getIconForValue(String valueAsString, int size) {
        if ("true".equalsIgnoreCase(valueAsString)) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/attachments/server/images/bueroklammer_16.png");
        }
        return null;
    }

    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/attachments/server/images/bueroklammer_16.png");
        }
        if (iconSize <= 32) {
            return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/attachments/server/images/bueroklammer_16@2x.png");
        }
        return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/attachments/server/images/bueroklammer_16@3x.png");
    }

    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation(Tickets.ATTRIBUTE_ATTACHMENTS.getKey(), sortGroupKey -> {
            String displayName = AttachmentsServerPlugin.MSG.getMsg("field.attachments.hasnoattachments", new Object[0]);
            if ("true".equalsIgnoreCase((String)sortGroupKey)) {
                displayName = AttachmentsServerPlugin.MSG.getMsg("field.attachments.hasattachments", new Object[0]);
            }
            String iconKey = sortGroupKey;
            return new SortGroup(displayName, "true".equalsIgnoreCase((String)sortGroupKey), iconKey);
        }){

            public String getSortGroupKey(TicketVO ticket) {
                return String.valueOf(ticket.hasAttachments());
            }
        };
    }

    @Nullable
    public FieldSettingsType getDisplayType() {
        return TicketFieldSettings.TYPE_OTHER;
    }

    public String getDescription() {
        return AttachmentsServerPlugin.MSG.getMsgAllowMissing("field.attachments.description", new Object[0]);
    }

    public TranslationKey getLabelTranslationKey() {
        return new TranslationKey("attachments", AttachmentsServerPlugin.MSG.getBundle().getBaseBundleName(), "de", "field.attachments");
    }
}

