/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.shared;

import java.util.List;

public class ValidationUtils {
    public static void throwExceptionIfNull(Object object, String objectName) {
        if (object == null) {
            throw new IllegalArgumentException(objectName + " must not be null ");
        }
    }

    public static void throwExceptionIfNullOrEmptyAfterTrim(String object, String objectName) {
        if (object == null || object.trim().isEmpty()) {
            throw new IllegalArgumentException(objectName + " must not be null, contain only whitespaces or be empty");
        }
    }

    public static void throwExceptionIfNullOrNegative(Number object, String objectName) {
        if (object == null || object.intValue() < 0) {
            throw new IllegalArgumentException(objectName + " must not be null or negative");
        }
    }

    public static void throwExceptionIfNotGreaterThanZero(long value, String valueName) {
        if (value <= 0L) {
            throw new IllegalArgumentException(valueName + " must not be negative or zero");
        }
    }

    public static void throwExceptionIfNegative(int value, String valueName) {
        if (value < 0) {
            throw new IllegalArgumentException(valueName + " must not be negative");
        }
    }

    public static <T> void throwExceptionIfListContainsNull(List<T> list, String listName) {
        for (T element : list) {
            if (element != null) continue;
            throw new IllegalArgumentException("list " + listName + " must not contain elements which are null");
        }
    }

    public static <T> void throwExceptionIfListIsEmpty(List<T> list, String listName) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("list " + listName + " must not be empty");
        }
    }
}

