/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class PluggableTicketSearchTagAttachmentNames
extends PluggableTicketSearchTag<List<String>> {
    public static final String KEY = "attachmentnames";
    private AttachmentDAO attachmentDAO;

    public PluggableTicketSearchTagAttachmentNames() {
        super(PluggableTicketSearchTagAttachmentNames.createSearchTag());
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        if (attachmentDAO == null) {
            throw new IllegalArgumentException("attachmentDAO must not be null");
        }
        this.attachmentDAO = attachmentDAO;
    }

    private static SearchTag createSearchTag() {
        SearchTokenizer tokenizer = (value, type) -> {
            if (value == null) {
                return Collections.emptySet();
            }
            switch (type) {
                case 3: {
                    List attachmentNames = (List)value;
                    if (attachmentNames.isEmpty()) {
                        return Collections.emptySet();
                    }
                    HashSet<String> tokensToIndex = new HashSet<String>();
                    for (String attName : attachmentNames) {
                        tokensToIndex.add(attName);
                        tokensToIndex.addAll(TextSearchTokenizer.DEFAULT.tokens((Object)attName, type));
                    }
                    return tokensToIndex;
                }
                case 1: {
                    return TextSearchTokenizer.DEFAULT.tokens(value, type);
                }
            }
            return Collections.singleton((String)value);
        };
        return new SearchTag(KEY, tokenizer, 100, () -> AttachmentsServerPlugin.MSG.getMsg("searchtag.attachmentnames", new Object[0])){

            public boolean isPhraseContainsIn(String normalizePhrase, Object val) {
                for (String fileName : (List)val) {
                    if (!super.isPhraseContainsIn(normalizePhrase, (Object)fileName)) continue;
                    return true;
                }
                return false;
            }

            public boolean isTextSearchEnabled() {
                return HDUsersAndGroups.isSupporter();
            }
        };
    }

    public List<String> getValue(int ticketID) {
        if (this.attachmentDAO == null) {
            throw new IllegalStateException("value provider is not set");
        }
        try {
            return this.attachmentDAO.getFileNamesFromAttachments(AttachmentOwnerType.TicketAttachment, ticketID);
        }
        catch (SQLException ex) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)ex);
            return Collections.emptyList();
        }
    }

    public void valueChanged(int ticketID, List<String> oldNames, List<String> newNames) {
        for (PluggableTicketSearchTag.PluggableTicketSearchTagValueChangeListener listener : this.getValueChangeListeners()) {
            try {
                listener.valueChanged(ticketID, oldNames, newNames);
            }
            catch (Throwable t) {
                HDLogger.error((Object)t);
            }
        }
    }
}

