/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.cache.MemoryStoreMap;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAO;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAOCacheCleaner;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.plugin.veto.VetoManager;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class AttachmentDAOWithCache
implements AttachmentDAO,
AttachmentDAOCacheCleaner {
    private final AttachmentDAO attDAO;
    private final Map<AttachmentOwnerType, MemoryStoreMap<Integer, List<String>>> attFileNameCacheMap = new HashMap<AttachmentOwnerType, MemoryStoreMap<Integer, List<String>>>();
    private final int ATT_FILE_NAME_CACHE_TIMEOUT_IN_SECONDS = 1800;
    private GetFileNamesFromAttachmentsMethod getFileNamesFromAttachmentsMethod;

    public AttachmentDAOWithCache(AttachmentDAO attachmentDAO) {
        if (attachmentDAO == null) {
            throw new IllegalArgumentException("attachmentDAO must not be null");
        }
        if (attachmentDAO instanceof AttachmentDAOWithCache) {
            throw new IllegalArgumentException("duplicate attachmentDAO cache");
        }
        this.attDAO = attachmentDAO;
        this.getFileNamesFromAttachmentsMethod = (type, id) -> {
            if (VetoManager.getInstance().isCurrentlyVetoed()) {
                return this.attDAO.getFileNamesFromAttachments(type, id);
            }
            this.getFileNamesFromAttachmentsMethod = (attType, oID) -> {
                MemoryStoreMap<Integer, List<String>> cache = this.getAttFileNameCache(attType);
                Integer ownerID = oID;
                try (ServerLock lock = this.getLockForAttOwner(attType, ownerID);){
                    List<String> attNames = (List<String>)cache.get((Object)ownerID);
                    if (attNames == null) {
                        attNames = Collections.unmodifiableList(this.attDAO.getFileNamesFromAttachments(attType, oID));
                        cache.put((Object)ownerID, attNames);
                    }
                    List<String> list = attNames;
                    return list;
                }
            };
            return this.getFileNamesFromAttachmentsMethod.getFileNamesFromAttachments(type, id);
        };
    }

    @Override
    public void createAttachment(AttachmentRow row) throws SQLException {
        this.attDAO.createAttachment(row);
        this.clearAttachmentFileNames(row.getType(), row.getOwnerId());
    }

    @Override
    public void removeAttachment(AttachmentKey key) throws SQLException {
        this.attDAO.removeAttachment(key);
        this.clearAttachmentFileNames(key.getType(), key.getOwnerId());
    }

    @Override
    public AttachmentRow getAttachment(AttachmentKey key) throws SQLException {
        return this.attDAO.getAttachment(key);
    }

    @Override
    public List<AttachmentRow> getAttachments(AttachmentOwnerType type, int id) throws SQLException {
        return this.attDAO.getAttachments(type, id);
    }

    @Override
    public List<AttachmentRow> getAttachments(AttachmentOwnerType type, int id, int stepId) throws SQLException {
        return this.attDAO.getAttachments(type, id, stepId);
    }

    @Override
    public void updateAttachment(AttachmentKey key, String checksum, long fileLength, long lastModified) throws SQLException {
        this.attDAO.updateAttachment(key, checksum, fileLength, lastModified);
    }

    @Override
    public int countAttachments(AttachmentOwnerType type, int id, boolean includeEmbedded) throws SQLException {
        return this.attDAO.countAttachments(type, id, includeEmbedded);
    }

    @Override
    public int countAttachments(AttachmentOwnerType type, List<Integer> ownerIds, boolean includeEmbedded) throws SQLException {
        return this.attDAO.countAttachments(type, ownerIds, includeEmbedded);
    }

    @Override
    public void createAttachmentFile(AttachmentFileRow row) throws SQLException {
        this.attDAO.createAttachmentFile(row);
    }

    @Override
    public void removeAttachmentFile(String checksum, long fileLength) throws SQLException {
        this.attDAO.removeAttachmentFile(checksum, fileLength);
    }

    @Override
    public AttachmentFileRow getAttachmentFile(String checksum, long fileLength) throws SQLException {
        return this.attDAO.getAttachmentFile(checksum, fileLength);
    }

    @Override
    public int getNumberOfAttachmentsForFile(String checksum, long fileLength) throws SQLException {
        return this.attDAO.getNumberOfAttachmentsForFile(checksum, fileLength);
    }

    @Override
    public List<AttachmentRow> getAttachmentsForFile(String checksum, long fileLength) throws SQLException {
        return this.attDAO.getAttachmentsForFile(checksum, fileLength);
    }

    @Override
    public List<AttachmentRow> getAttachmentsForFile(String checksum, long fileLength, int entryLimit) throws SQLException {
        return this.attDAO.getAttachmentsForFile(checksum, fileLength, entryLimit);
    }

    @Override
    public AttachmentFileRow getAttachmentFile(AttachmentKey key) throws SQLException {
        return this.attDAO.getAttachmentFile(key);
    }

    @Override
    public List<String> getFileNamesFromAttachments(AttachmentOwnerType type, int id) throws SQLException {
        return this.getFileNamesFromAttachmentsMethod.getFileNamesFromAttachments(type, id);
    }

    private ServerLock getLockForAttOwner(AttachmentOwnerType type, @Nonnull Integer ownerID) {
        return ThreadUtils.getLock((Object)("attCache_" + type.getAttachmentSubContext() + "_" + ownerID.toString()));
    }

    private MemoryStoreMap<Integer, List<String>> getAttFileNameCache(AttachmentOwnerType type) {
        MemoryStoreMap<Integer, List<String>> cache = this.attFileNameCacheMap.get(type);
        if (cache != null) {
            return cache;
        }
        try (ServerLock lock = ThreadUtils.getLock((Object)("attFileNameCache_" + type.getAttachmentSubContext()));){
            MemoryStoreMap memoryStoreMap = this.attFileNameCacheMap.computeIfAbsent(type, k -> {
                MemoryStoreMap map = new MemoryStoreMap();
                map.setTimeout(1800, true);
                return map;
            });
            return memoryStoreMap;
        }
    }

    @Override
    public List<String> getFileNamesFromAttachments(AttachmentOwnerType type, int id, int stepId) throws SQLException {
        return this.attDAO.getFileNamesFromAttachments(type, id, stepId);
    }

    @Override
    public Map<AttachmentRow, AttachmentFileRow> getFullAttachmentDataForOwner(AttachmentOwnerType type, List<Integer> bundledTicketIds, boolean includeEmbeddedImages) throws SQLException {
        return this.attDAO.getFullAttachmentDataForOwner(type, bundledTicketIds, includeEmbeddedImages);
    }

    @Override
    public List<AttachmentKey> getAttachmentKeys(AttachmentOwnerType type) throws SQLException {
        return this.attDAO.getAttachmentKeys(type);
    }

    @Override
    public List<AttachmentFileRow> getAllAttachmentFiles() throws SQLException {
        return this.attDAO.getAllAttachmentFiles();
    }

    @Override
    public Map<AttachmentFileRow, Integer> getAllAttachmentFilesWithReferenceCount() throws SQLException {
        return this.attDAO.getAllAttachmentFilesWithReferenceCount();
    }

    @Override
    public int getNumberOfAttachmentFilesWhichAreNotReferencedByAttachments() throws SQLException {
        return this.attDAO.getNumberOfAttachmentFilesWhichAreNotReferencedByAttachments();
    }

    @Override
    public long getTotalLengthOfAttachmentFilesWhichAreNotReferencedByAttachments() throws SQLException {
        return this.attDAO.getTotalLengthOfAttachmentFilesWhichAreNotReferencedByAttachments();
    }

    @Override
    public int removeAttachmentFilesWhichAreNotReferencedByAttachments() throws SQLException {
        return this.attDAO.removeAttachmentFilesWhichAreNotReferencedByAttachments();
    }

    @Override
    public List<AttachmentFileRow> getAttachmentFilesWhichAreNotReferencedByAttachments() throws SQLException {
        return this.attDAO.getAttachmentFilesWhichAreNotReferencedByAttachments();
    }

    @Override
    public void updateAttachmentFilePath(String checksum, long fileLength, String parentDirPath) throws SQLException {
        this.attDAO.updateAttachmentFilePath(checksum, fileLength, parentDirPath);
    }

    @Override
    public void clearAttachmentFileNames(AttachmentOwnerType type, Integer ownerID) {
        MemoryStoreMap<Integer, List<String>> cache = this.getAttFileNameCache(type);
        try (ServerLock lock = this.getLockForAttOwner(type, ownerID);){
            cache.remove((Object)ownerID);
        }
    }

    private static interface GetFileNamesFromAttachmentsMethod {
        public List<String> getFileNamesFromAttachments(AttachmentOwnerType var1, int var2) throws SQLException;
    }
}

