/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.mail;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.mail.MailAttachment;
import com.inet.helpdesk.core.mail.MailMetaData;
import com.inet.helpdesk.core.mail.MailUtilities;
import com.inet.helpdesk.core.mail.SendAutoMailExtension;
import com.inet.helpdesk.plugins.attachments.server.AttachmentFileService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.mail.ImageReferenceReplacer;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentFilePathBuilder;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.persistence.PersistenceEntry;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class AutoMailAttachmentExtension
implements SendAutoMailExtension {
    private AttachmentService attachmentservice;
    private AttachmentFileService fileService;

    public void setDependencies(AttachmentService attachmentservice, AttachmentFileService fileService) {
        this.attachmentservice = attachmentservice;
        this.fileService = fileService;
    }

    public String extendEmail(String emailText, List<MailAttachment> emailAttachmentsList, MailMetaData mailMetaData) {
        Map<AttachmentRow, AttachmentFileRow> fullAttachmentDataForTickets;
        ArrayList<Integer> bundledTicketIds = new ArrayList<Integer>();
        bundledTicketIds.add(mailMetaData.getTicketId());
        try {
            fullAttachmentDataForTickets = this.attachmentservice.getFullAttachmentDataFor(AttachmentOwnerType.TicketAttachment, bundledTicketIds);
        }
        catch (SQLException e) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_DATABASE_ERROR));
            return emailText;
        }
        if (fullAttachmentDataForTickets.isEmpty()) {
            return emailText;
        }
        if (mailMetaData.isSendMailAsHtml()) {
            emailText = this.replaceEmbeddedImageUrlsWithRestfulPath(emailText, emailAttachmentsList, mailMetaData, fullAttachmentDataForTickets);
            emailText = this.replaceEmbeddedImageUrlsWithOldPath(emailText, emailAttachmentsList, mailMetaData, fullAttachmentDataForTickets);
        } else {
            this.addEmbeddedOrNonembeddedAttachments(emailAttachmentsList, fullAttachmentDataForTickets, att -> mailMetaData.getListOfReasWhoseTextIsUsedInMail().contains(att.getStepId()) && att.isEmbedded());
        }
        if (!mailMetaData.isBlackListedBecauseofSize() && mailMetaData.isSendAttachments()) {
            this.addExternalAttachments(emailAttachmentsList, fullAttachmentDataForTickets);
        }
        return emailText;
    }

    private void addExternalAttachments(List<MailAttachment> emailAttachmentsList, Map<AttachmentRow, AttachmentFileRow> fullAttachmentDataForTickets) {
        this.addEmbeddedOrNonembeddedAttachments(emailAttachmentsList, fullAttachmentDataForTickets, att -> !att.isEmbedded());
    }

    private void addEmbeddedOrNonembeddedAttachments(List<MailAttachment> emailAttachmentsList, Map<AttachmentRow, AttachmentFileRow> fullAttachmentDataForTickets, Predicate<AttachmentRow> filter) {
        for (Map.Entry<AttachmentRow, AttachmentFileRow> en : fullAttachmentDataForTickets.entrySet()) {
            AttachmentRow attachmentRow = en.getKey();
            AttachmentFileRow file = en.getValue();
            if (!filter.test(attachmentRow)) continue;
            PersistenceEntry attachmentFile = this.fileService.getAttachmentFile(file.getFilePath());
            MailUtilities.addToList((PersistenceEntry)attachmentFile, (String)attachmentRow.getFileName(), (boolean)false, emailAttachmentsList);
        }
    }

    private String replaceEmbeddedImageUrlsWithOldPath(String emailText, List<MailAttachment> emailAttachmentsList, MailMetaData mailMetaData, Map<AttachmentRow, AttachmentFileRow> fullAttachmentDataForTickets) {
        int start = 0;
        String regexForPathWithoutStepId = "/Attachments_\\d+/\\d+_.*";
        while ((start = ((String)emailText).indexOf("src=\"/Attachments_", start)) > -1) {
            int end = ((String)emailText).indexOf(34, start + 18);
            String src = ((String)emailText).substring(start + 5, end);
            if (src.matches(regexForPathWithoutStepId)) {
                int startFileName = ((String)emailText).indexOf("/", start + 17) + 1;
                String fileName = ((String)emailText).substring(startFileName, end);
                AttachmentDescription description = new AttachmentDescription();
                description.setPrefixedNameWithExtension(fileName);
                AttachmentsServerPlugin.LOGGER.debug((Object)("FOUND: " + fileName));
                try {
                    AttachmentKey key = new AttachmentKey(AttachmentOwnerType.TicketAttachment, description.getOwnerId(), description.getStepId(), -1, description.getFileName());
                    AttachmentFileRow file = this.getAttachmentFile(key, fullAttachmentDataForTickets);
                    if (file != null) {
                        PersistenceEntry attachmentFile = this.fileService.getAttachmentFile(file.getFilePath());
                        emailText = ((String)emailText).substring(0, start + 5) + "cid:" + MailUtilities.addToList((PersistenceEntry)attachmentFile, (String)description.getFileName(), (boolean)true, emailAttachmentsList) + ((String)emailText).substring(end);
                        continue;
                    }
                    AttachmentsServerPlugin.LOGGER.warn((Object)("Attachment for Email not found: " + fileName));
                    ++start;
                }
                catch (IllegalArgumentException ex) {
                    AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_FILE_ERROR));
                    ++start;
                }
                continue;
            }
            AttachmentsServerPlugin.LOGGER.warn((Object)("Attachment for Email not found: " + src));
            ++start;
        }
        return emailText;
    }

    private String replaceEmbeddedImageUrlsWithRestfulPath(String emailText, List<MailAttachment> emailAttachmentsList, MailMetaData mailMetaData, Map<AttachmentRow, AttachmentFileRow> fullAttachmentDataForTickets) {
        return ImageReferenceReplacer.genericReplaceImageSources(emailText, src -> {
            if (!src.startsWith("Attachments")) {
                return src;
            }
            String fileName = src.substring("Attachments".length());
            fileName = EncodingFunctions.decodeUrlPath((String)fileName);
            fileName = StringFunctions.decodeHTML((String)fileName);
            try {
                AttachmentKey key = AttachmentFilePathBuilder.convertRestfulPathToKey(fileName);
                AttachmentFileRow file = this.getAttachmentFile(key, fullAttachmentDataForTickets);
                if (file == null) {
                    try {
                        AttachmentRow ar = this.attachmentservice.getAttachment(key);
                        if (ar != null) {
                            file = this.attachmentservice.getAttachmentFile(ar.getChecksum(), ar.getFileLength());
                        }
                    }
                    catch (Exception ex) {
                        AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.MAIL_CREATION_ERROR));
                    }
                }
                if (file != null) {
                    PersistenceEntry attachmentFile = this.fileService.getAttachmentFile(file.getFilePath());
                    return "cid:" + EncodingFunctions.encodeUrlPath((String)MailUtilities.addToList((PersistenceEntry)attachmentFile, (String)key.getFileName(), (boolean)true, (List)emailAttachmentsList));
                }
                AttachmentsServerPlugin.LOGGER.warn((Object)("Attachment for Email not found: " + fileName));
                return src;
            }
            catch (IllegalArgumentException ex) {
                AttachmentsServerPlugin.LOGGER.warn((Object)ex);
                return src;
            }
        });
    }

    private AttachmentFileRow getAttachmentFile(AttachmentKey key, Map<AttachmentRow, AttachmentFileRow> fullAttachmentDataForTickets) {
        for (Map.Entry<AttachmentRow, AttachmentFileRow> en : fullAttachmentDataForTickets.entrySet()) {
            if (!en.getKey().equals(key)) continue;
            return en.getValue();
        }
        return null;
    }
}

