/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.extensions.mail;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.CreateTicketExtension;
import com.inet.helpdesk.core.ticketmanager.extension.EmailReceivedArgument;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.extensions.AddAttachmentsExtensionData;
import com.inet.helpdesk.plugins.attachments.server.mail.ImageReferenceReplacer;
import com.inet.helpdesk.shared.rpc.LargeContent;
import com.inet.lib.util.NetworkFunctions;
import com.inet.mail.api.AttachedFile;
import com.inet.shared.http.upload.AttachmentType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;

public class EmailAttachmentExtension
implements CreateTicketExtension,
TicketActionExtension {
    private static final ConfigValue<String> SERVER_URL = new ConfigValue<String>(ConfigKey.SERVER_URL){

        public String get() {
            Object url = (String)super.get();
            if (url == null || ((String)url).isEmpty()) {
                HDLogger.warn((Object)("[EmailReader] SERVER_URL is not valid:" + (String)url));
                url = "http://" + NetworkFunctions.getLocalHostName() + ":" + String.valueOf(ServerUtilities.GUI_PORT.get());
            }
            if (((String)url).endsWith("/")) {
                url = ((String)url).substring(0, ((String)url).length() - 1);
            }
            return url;
        }
    };
    private ExtensionArguments arguments;
    private EmailReceivedArgument emailData;

    public EmailAttachmentExtension(ExtensionArguments arguments, EmailReceivedArgument emailData) {
        this.arguments = arguments;
        this.emailData = emailData;
    }

    public void beforeCreate(OperationChangedTicket newTicket, OperationNewReaStep anfrageStep, TicketSubOperations operations) {
        this.convertMailAttachmentsToNormalFormat(anfrageStep.getText(), this.emailData.getAttachments(), this.arguments);
    }

    public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
        this.convertMailAttachmentsToNormalFormat(reaStep.getText(), this.emailData.getAttachments(), this.arguments);
    }

    private void convertMailAttachmentsToNormalFormat(MutableReaStepText contentText, List<AttachedFile> attachments, ExtensionArguments argument) {
        List<LargeContent> atts = this.createLargeContentData(attachments, contentText.getText());
        String httpHostTag = contentText.isHtml() ? null : (String)SERVER_URL.get();
        String changedContent = ImageReferenceReplacer.replaceWithLargeContentFilename(attachments, atts, contentText.getText(), httpHostTag);
        contentText.setText(changedContent);
        if (!atts.isEmpty()) {
            argument.put(AttachmentsServerPlugin.EXTARG_ATTACHMENTS, (Object)new AddAttachmentsExtensionData(atts));
        }
    }

    private List<LargeContent> createLargeContentData(List<AttachedFile> attFiles, String mailContent) {
        ArrayList<String> uniqueAttachmentNames = new ArrayList<String>();
        ArrayList<LargeContent> lcs = new ArrayList<LargeContent>(attFiles.size());
        for (AttachedFile attFile : attFiles) {
            final File file = attFile.getFile();
            LargeContent attachment = new LargeContent(new LargeContent.InputStreamProvider(){

                public long getSize() {
                    return file.length();
                }

                public InputStream getStream() {
                    try {
                        return new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_FILE_ERROR));
                        return null;
                    }
                }
            });
            attachment.setName(this.createUniqueFileName(attFile.getFileName(), uniqueAttachmentNames));
            attachment.setLastModified(file.lastModified());
            attachment.setContentType(this.getTypeOfAttachment(attFile, mailContent));
            lcs.add(attachment);
        }
        return lcs;
    }

    @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="not for security critical content used")
    private String createUniqueFileName(String name, List<String> uniqueAttachmentNames) {
        String original = name;
        String ext = "";
        if (((String)name).lastIndexOf(".") > -1) {
            original = ((String)name).substring(0, ((String)name).lastIndexOf("."));
            ext = ((String)name).substring(((String)name).lastIndexOf("."));
        }
        while (uniqueAttachmentNames.contains(name)) {
            String zeros = "000000";
            Random rnd = new Random();
            Object s = Integer.toString(rnd.nextInt(0x1000000), 16);
            s = zeros.substring(((String)s).length()) + (String)s;
            name = original + (String)s + ext;
        }
        uniqueAttachmentNames.add((String)name);
        return name;
    }

    private AttachmentType getTypeOfAttachment(AttachedFile anl, String mailContent) {
        String contentId;
        boolean hasContentId;
        String[] contentIdHeader = anl.getContentID();
        boolean bl = hasContentId = contentIdHeader != null && contentIdHeader.length > 0;
        if (hasContentId && EmailAttachmentExtension.doesReferenceWithContentIdOccurInMailContent(contentId = contentIdHeader[0], mailContent)) {
            return AttachmentType.EmbeddedImage;
        }
        return AttachmentType.Attachment;
    }

    private static boolean doesReferenceWithContentIdOccurInMailContent(String contentId, String mailContent) {
        if (contentId == null || contentId.isEmpty()) {
            return false;
        }
        if (contentId.startsWith("<")) {
            contentId = contentId.substring(1);
        }
        if (contentId.endsWith(">")) {
            contentId = contentId.substring(0, contentId.length() - 1);
        }
        return mailContent.contains("src=\"cid:" + contentId + "\"") || mailContent.contains("href=\"cid:" + contentId + "\"");
    }
}

