/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.datacare;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentDataCare;
import com.inet.helpdesk.plugins.attachments.server.datacare.AttachmentPreviewEntry;
import com.inet.helpdesk.plugins.attachments.server.datacare.FoundAttachmentsWithMissingFiles;
import com.inet.helpdesk.plugins.attachments.server.datacare.UnrelatedAttachmentData;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCarePreview;
import com.inet.helpdesk.plugins.maintenance.server.datacare.api.DataCareTask;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AttachmentsWithMissingFilesDataCareTask
implements DataCareTask {
    @Nonnull
    public String getExtensionName() {
        return "datacare.attachmentswithmissingfiles";
    }

    public String getTitle() {
        return AttachmentsServerPlugin.MSG.getMsg("datacare.attachmentswithmissingfiles.title", new Object[0]);
    }

    public String getDescription() {
        return AttachmentsServerPlugin.MSG.getMsg("datacare.attachmentswithmissingfiles.description", new Object[0]);
    }

    public int getPriority() {
        return 320;
    }

    public DataCarePreview getPreview(HashMap<String, String> parameters) throws ServerDataException {
        AttachmentDataCare attachmentDataCare = (AttachmentDataCare)ServerPluginManager.getInstance().getSingleInstance(AttachmentDataCare.class);
        FoundAttachmentsWithMissingFiles attachmentsWithMissingFiles = attachmentDataCare.findAttachmentsWithMissingFiles();
        ArrayList<AttachmentPreviewEntry> list = new ArrayList<AttachmentPreviewEntry>();
        for (UnrelatedAttachmentData att : attachmentsWithMissingFiles.getExemplaryAttachments()) {
            list.add(new AttachmentPreviewEntry().from(att));
        }
        int attFileCount = attachmentsWithMissingFiles.getFoundAttachmentFilesCount();
        String previewMsg = attFileCount > 0 ? AttachmentsServerPlugin.MSG.getMsg("datacare.attachmentswithmissingfiles.preview", new Object[]{attFileCount, attachmentsWithMissingFiles.hasFoundMoreAttachmentFiles() ? 1 : 0}) : AttachmentsServerPlugin.MSG.getMsg("datacare.attachmentswithmissingfiles.nopreview", new Object[0]);
        DataCarePreview preview = new DataCarePreview();
        preview.setPreviewMsg(previewMsg);
        preview.setExamples(list);
        return preview;
    }

    @Nullable
    public GUID executeDelete(HashMap<String, String> parameters) throws ServerDataException {
        AttachmentDataCare attachmentDataCare = (AttachmentDataCare)ServerPluginManager.getInstance().getSingleInstance(AttachmentDataCare.class);
        attachmentDataCare.deleteAttachmentsWithMissingFiles();
        return null;
    }
}

