/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.data.TempDirectory;
import com.inet.helpdesk.plugins.attachments.server.mail.ImageReferenceReplacer;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.MimeMessageContent;
import com.inet.helpdesk.plugins.attachments.shared.util.FileWriter;
import com.inet.helpdesk.plugins.attachments.shared.util.FileWriterFactory;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.logging.Logger;
import com.inet.mail.api.AttachedFile;
import com.inet.mail.api.MailAttachmentUtilities;
import com.inet.mail.api.MailEncodingUtilities;
import com.inet.mail.api.PartHandler;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

@InternalApi
public class MessageMim {
    public static final String FROM = "From";
    public static final String CC = "Cc";
    public static final String TO = "To";
    private String subject;
    private String textBody;
    private String fromDisplay;
    private String toDisplay;
    private String ccDisplay;
    private boolean ishtml = false;
    private Vector<AttachedFile> allFiles;
    private long sendDate = 0L;
    private Path tempAttachmentsDir;
    private final Logger logger;

    public MessageMim(MimeMessage msg, String uniquePrefix, Logger logger) throws Exception {
        this.logger = logger;
        this.subject = MailEncodingUtilities.tryEncoding((String)msg.getSubject(), (boolean)true, (boolean)false);
        this.fromDisplay = this.getAddress(msg, null, FROM);
        this.toDisplay = this.getAddress(msg, Message.RecipientType.TO, TO);
        this.ccDisplay = this.getAddress(msg, Message.RecipientType.CC, CC);
        ArrayList listOfParts = new ArrayList();
        MailAttachmentUtilities.fetchParts((Part)msg, listOfParts, (boolean)false);
        for (int i = 0; i < listOfParts.size(); ++i) {
            ((PartHandler)listOfParts.get(i)).checkPart(listOfParts, i - 1);
        }
        PartHandler textPart = PartHandler.getTextBodyPart(listOfParts);
        this.ishtml = textPart.isHtmlPart();
        UnsupportedEncodingException fehler = null;
        try {
            this.textBody = (String)textPart.getPart().getContent();
        }
        catch (UnsupportedEncodingException ex) {
            if (textPart.getContentTyp().indexOf("utf-7") > -1) {
                try {
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    textPart.getPart().writeTo((OutputStream)bao);
                    this.textBody = MailEncodingUtilities.decodeUTF7((byte[])bao.toByteArray(), (boolean)this.ishtml);
                }
                catch (UnsupportedEncodingException innerex) {
                    fehler = innerex;
                }
            }
            fehler = ex;
        }
        try {
            Date sentDate = msg.getSentDate();
            if (sentDate != null) {
                this.sendDate = sentDate.getTime();
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        if (fehler != null) {
            this.textBody = UtilityFunctions.stack2string((Throwable)fehler);
            this.ishtml = false;
        }
        String aknowledgeString = null;
        if (listOfParts.size() > 0) {
            this.tempAttachmentsDir = TempDirectory.ATTACHMENTS_TEMP.resolve(uniquePrefix);
            this.allFiles = new Vector();
            for (int i = 0; i < listOfParts.size(); ++i) {
                PartHandler part = (PartHandler)listOfParts.get(i);
                String end = part.getFileExtention();
                String fileN = part.getFileName();
                if (".pif".equalsIgnoreCase(end) || ".scr".equalsIgnoreCase(end)) continue;
                AttachedFile anlage = new AttachedFile(MailAttachmentUtilities.getFileName((String)fileN, (String)end, this.allFiles));
                anlage.setLocation(part.getContentLocation());
                anlage.setContentID(part.getContentID());
                this.setFile(anlage.getFileName(), this.tempAttachmentsDir, anlage);
                if (part.getPartContentString() != null) {
                    this.writeToFile(anlage.getFile(), part.getPartContentString().getBytes());
                    this.allFiles.add(anlage);
                    continue;
                }
                if (this.writePartToFile(anlage.getFile(), part.getPart())) {
                    this.allFiles.add(anlage);
                    continue;
                }
                if (aknowledgeString != null) continue;
                aknowledgeString = "Attachment " + fileN;
            }
        }
        if (this.ishtml && this.allFiles != null) {
            this.textBody = ImageReferenceReplacer.replaceImageSources(this.allFiles, this.textBody, null);
        }
    }

    public Path getTempAttachmentsDir() {
        return this.tempAttachmentsDir;
    }

    public MimeMessageContent getResult() {
        MimeMessageContent result = new MimeMessageContent();
        result.setSubject(this.subject);
        result.setSender(this.fromDisplay);
        result.setReceiver(this.toDisplay);
        result.setCc(this.ccDisplay);
        result.setText(this.textBody);
        result.setHtml(this.ishtml);
        result.setSendTime(this.sendDate);
        result.setAttachmentList(this.getAttachments());
        return result;
    }

    private List<AttachmentDescription> getAttachments() {
        if (this.allFiles != null) {
            ArrayList<AttachmentDescription> attachments = new ArrayList<AttachmentDescription>();
            for (AttachedFile file : this.allFiles) {
                AttachmentDescription attachment = new AttachmentDescription();
                attachment.setAttachmentType(AttachmentOwnerType.Temp);
                String path = MessageMim.encode(file.getFileName());
                attachment.setFilePath(path);
                attachment.setPrefixedNameWithExtension(file.getFile().getName());
                attachment.setLastModified(this.sendDate > 0L ? this.sendDate : System.currentTimeMillis());
                attachment.setFilesize(file.getFile().length());
                attachments.add(attachment);
            }
            return attachments;
        }
        return null;
    }

    protected static String encode(String in) {
        in = in.replace('\\', '/');
        try {
            String requestedFile = new URI("http", "localhost", in, null).toASCIIString();
            in = requestedFile.substring(requestedFile.indexOf("localhost") + 9);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writePartToFile(File file, Part p) {
        boolean erfolg = true;
        InputStream is = null;
        try {
            is = p.getInputStream();
            FileWriter fileWriter = FileWriterFactory.getInstance().getFileWriterInstance();
            fileWriter.writeStreamToFile(file, is, null);
        }
        catch (Exception e) {
            erfolg = false;
            try {
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.logger.error((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
        return erfolg;
    }

    private void writeToFile(File file, byte[] content) {
        try {
            FileWriter fileWriter = FileWriterFactory.getInstance().getFileWriterInstance();
            fileWriter.writeContentToFile(file, content);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    private void setFile(String name, Path subDir, AttachedFile anlage) {
        if (!Files.exists(subDir, new LinkOption[0])) {
            try {
                Files.createDirectories(subDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
            }
        }
        if (name.indexOf(92) > 0) {
            name = name.substring(name.lastIndexOf(92) + 1);
        }
        name = MailAttachmentUtilities.normalisiertenFileName((String)name);
        Path filePath = subDir.resolve(name);
        File file = filePath.toFile();
        filePath = TempDirectory.ATTACHMENTS_TEMP.getParent().relativize(filePath);
        anlage.setFileName("/Attachments/" + filePath.toString().replace('\\', '/'));
        anlage.setFile(file);
    }

    private String getAddress(MimeMessage msg, Message.RecipientType recipients, String headerline) {
        StringBuilder builder;
        block7: {
            Address[] addrs = null;
            builder = new StringBuilder();
            try {
                addrs = recipients == null ? msg.getFrom() : msg.getRecipients(recipients);
                if (addrs == null) break block7;
                try {
                    for (int i = 0; i < addrs.length; ++i) {
                        InternetAddress address = ((InternetAddress[])addrs)[i];
                        MessageMim.addAddress(address.getAddress(), address.getPersonal(), builder);
                    }
                }
                catch (Exception innere) {
                    this.logger.error((Throwable)innere);
                }
            }
            catch (Exception ex) {
                try {
                    MessageMim.getDisplayAddressesFromHeader((Message)msg, headerline, builder, this.logger);
                }
                catch (Exception innere) {
                    this.logger.error((Throwable)innere);
                }
            }
        }
        return builder.toString();
    }

    private static void getDisplayAddressesFromHeader(Message msg, String headerName, StringBuilder builder, Logger logger) throws MessagingException {
        String[] headerArray = msg.getHeader(headerName);
        if (headerArray == null) {
            logger.debug((Object)("No result for: getHeader(\"" + headerName + "\")"));
        } else {
            for (String element : headerArray) {
                String[] headerLine = MessageMim.splitAddress(element.trim());
                MessageMim.addAddress(headerLine[0], headerLine[1], builder);
            }
        }
    }

    private static String[] splitAddress(String address) {
        String[] result = new String[2];
        int start = address.indexOf(60);
        if (start > -1 && address.endsWith(">")) {
            result[0] = address.substring(start + 1, address.length() - 1);
            if (start > 0) {
                result[1] = MailEncodingUtilities.tryEncoding((String)address.substring(0, start), (boolean)true, (boolean)false);
            }
        } else if (address.indexOf(34) == -1 && address.indexOf(64) > -1) {
            result[0] = address;
        }
        return result;
    }

    private static void addAddress(String addressString, String personalString, StringBuilder builder) {
        if (addressString == null || addressString.length() == 0) {
            return;
        }
        int pos = addressString.lastIndexOf("_CN=");
        if (pos > -1) {
            addressString = addressString.substring(pos + 4);
        }
        if (builder.length() > 0) {
            builder.append(';');
        }
        if (personalString == null || personalString.trim().length() == 0) {
            builder.append('<').append(addressString).append('>');
        } else {
            builder.append('\"').append(personalString).append("\" <").append(addressString).append('>');
        }
    }
}

