/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.plugins.attachments.server.AttachmentDAOWithCache;
import com.inet.helpdesk.plugins.attachments.server.AttachmentFileService;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.ChecksumUtils;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.ValidationUtils;
import com.inet.plugin.ServerPluginManager;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttachmentRemover {
    private AttachmentDAOWithCache attachmentDAO;
    private AttachmentFileService attFileService;

    public AttachmentRemover(AttachmentDAOWithCache attachmentDAO, AttachmentFileService attFileService) {
        ValidationUtils.throwExceptionIfNull(attachmentDAO, "attachmentDAO");
        ValidationUtils.throwExceptionIfNull(attFileService, "attFileService");
        this.attachmentDAO = attachmentDAO;
        this.attFileService = attFileService;
    }

    public void removeDeviceAttachments(List<Integer> ownerIds) {
        ValidationUtils.throwExceptionIfNull(ownerIds, "list of owner ids");
        ValidationUtils.throwExceptionIfListContainsNull(ownerIds, "list of owner ids");
        if (ownerIds.isEmpty()) {
            return;
        }
        Map<AttachmentRow, AttachmentFileRow> fullAttachmentData = this.getFullAttachmentData(AttachmentOwnerType.DeviceAttachment, ownerIds);
        for (Map.Entry<AttachmentRow, AttachmentFileRow> attData : fullAttachmentData.entrySet()) {
            AttachmentRow attRow = attData.getKey();
            AttachmentFileRow attFileRow = attData.getValue();
            try {
                long fileLength;
                this.attachmentDAO.removeAttachment(attRow.getAttachmentKey());
                this.attachmentDAO.clearAttachmentFileNames(attRow.getType(), attRow.getOwnerId());
                String checksum = attFileRow.getChecksum();
                int numberOfAttachmentsForFile = this.attachmentDAO.getNumberOfAttachmentsForFile(checksum, fileLength = attFileRow.getFileLength());
                if (numberOfAttachmentsForFile != 0) continue;
                this.attachmentDAO.removeAttachmentFile(checksum, fileLength);
                this.attFileService.deleteFile(attFileRow.getFilePath());
            }
            catch (Exception e) {
                AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_DATA_ERROR));
            }
        }
    }

    public void removeAllUnrelatedTicketAttachmentsAndAllUnrelatedAttachmentFiles() {
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection connection = connectionFactory.getConnection();){
            this.removeAllUnrelatedTicketAttachments(connection);
            this.removeAllUnrelatedAttachmentFiles(connection);
        }
        catch (IOException | SQLException ex) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_DATA_ERROR));
        }
    }

    public void removeAllUnrelatedDeviceAttachmentsAndAllUnrelatedAttachmentFiles() {
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection connection = connectionFactory.getConnection();){
            this.removeAllUnrelatedDeviceAttachments(connection);
            this.removeAllUnrelatedAttachmentFiles(connection);
        }
        catch (IOException | SQLException ex) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_DATA_ERROR));
        }
    }

    private void removeAllUnrelatedTicketAttachments(Connection connection) throws SQLException {
        String sqlDeleteAttachments = String.format("DELETE FROM tblAttachments WHERE tblAttachments.type = %d AND NOT EXISTS (SELECT * FROM tblAuftraege WHERE tblAuftraege.AufID = tblAttachments.ownerId)", AttachmentOwnerType.TicketAttachment.getId());
        try (PreparedStatement pstm = connection.prepareStatement(sqlDeleteAttachments);){
            pstm.executeUpdate();
        }
    }

    private void removeAllUnrelatedDeviceAttachments(Connection connection) throws SQLException {
        String sqlDeleteAttachments = String.format("DELETE FROM tblAttachments WHERE tblAttachments.type = %d AND NOT EXISTS (SELECT * FROM tblGeraeteBestand WHERE tblGeraeteBestand.GerID = tblAttachments.ownerId)", AttachmentOwnerType.DeviceAttachment.getId());
        try (PreparedStatement pstm = connection.prepareStatement(sqlDeleteAttachments);){
            pstm.executeUpdate();
        }
    }

    private void removeAllUnrelatedAttachmentFiles(Connection connection) throws SQLException, IOException {
        String sqlSelect = "SELECT tblAttachmentFiles.checksum, tblAttachmentFiles.parentDirectoryPath, tblAttachmentFiles.filelength FROM tblAttachments RIGHT OUTER JOIN tblAttachmentFiles ON tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId WHERE tblAttachments.ownerId IS null";
        String sqlDeleteAttFiles = "DELETE FROM tblAttachmentFiles WHERE NOT EXISTS (SELECT * FROM tblAttachments WHERE tblAttachments.attachmentFileId = tblAttachmentFiles.attachmentFileId)";
        try (PreparedStatement pstmSelectUnrelatedAttFiles = connection.prepareStatement(sqlSelect);
             PreparedStatement pstmDeleteUnrelatedAttFiles = connection.prepareStatement(sqlDeleteAttFiles);){
            try (ResultSet rs = pstmSelectUnrelatedAttFiles.executeQuery();){
                while (rs.next()) {
                    String checksum = ChecksumUtils.bytesToHexString(rs.getBytes(1));
                    String path = rs.getString(2);
                    long fileLength = rs.getLong(3);
                    AttachmentFileRow attFileRow = new AttachmentFileRow(checksum, path, fileLength);
                    this.attFileService.deleteFile(attFileRow.getFilePath());
                }
            }
            pstmDeleteUnrelatedAttFiles.executeUpdate();
        }
    }

    private Map<AttachmentRow, AttachmentFileRow> getFullAttachmentData(AttachmentOwnerType type, List<Integer> ownerIds) {
        try {
            return this.attachmentDAO.getFullAttachmentDataForOwner(type, ownerIds, true);
        }
        catch (SQLException e) {
            AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_DATABASE_ERROR));
            return new HashMap<AttachmentRow, AttachmentFileRow>();
        }
    }
}

