/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.helpdesk.plugins.attachments.shared.model.AttachmentKey;

@JsonData
public class AttachmentRow {
    private AttachmentOwnerType type;
    private Integer ownerId;
    private Integer stepId;
    private Integer additionalId;
    private String checksum;
    private String fileName;
    private long fileLength;
    private boolean isEmbedded;
    private long lastModified;

    private AttachmentRow() {
    }

    public AttachmentRow(AttachmentKey key, String checksum, long fileLength, boolean isEmbedded, long lastModified) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (checksum == null || checksum.isEmpty()) {
            throw new IllegalArgumentException("checksum must not be null or empty");
        }
        if (fileLength < 0L) {
            throw new IllegalArgumentException("file length must not be negative");
        }
        if (lastModified < 0L) {
            throw new IllegalArgumentException("last modified value must not be negative");
        }
        this.type = key.getType();
        this.ownerId = key.getOwnerId();
        this.stepId = key.getStepId();
        this.additionalId = key.getAdditionalId();
        this.fileName = key.getFileName();
        this.checksum = checksum;
        this.fileLength = fileLength;
        this.isEmbedded = isEmbedded;
        this.lastModified = lastModified;
    }

    public AttachmentOwnerType getType() {
        return this.type;
    }

    public Integer getOwnerId() {
        return this.ownerId;
    }

    public Integer getStepId() {
        return this.stepId;
    }

    public Integer getAdditionalId() {
        return this.additionalId;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalId == null ? 0 : this.additionalId.hashCode());
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (int)(this.fileLength ^ this.fileLength >>> 32);
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.isEmbedded ? 1231 : 1237);
        result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
        result = 31 * result + (this.ownerId == null ? 0 : this.ownerId.hashCode());
        result = 31 * result + (this.stepId == null ? 0 : this.stepId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentRow other = (AttachmentRow)obj;
        if (this.additionalId == null ? other.additionalId != null : !this.additionalId.equals(other.additionalId)) {
            return false;
        }
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        if (this.fileLength != other.fileLength) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.isEmbedded != other.isEmbedded) {
            return false;
        }
        if (this.lastModified != other.lastModified) {
            return false;
        }
        if (this.ownerId == null ? other.ownerId != null : !this.ownerId.equals(other.ownerId)) {
            return false;
        }
        if (this.stepId == null ? other.stepId != null : !this.stepId.equals(other.stepId)) {
            return false;
        }
        return this.type == other.type;
    }

    public boolean equals(AttachmentKey other) {
        if (this.additionalId == null ? other.getAdditionalId() != null : !this.additionalId.equals(other.getAdditionalId())) {
            return false;
        }
        if (this.fileName == null ? other.getFileName() != null : !this.fileName.equals(other.getFileName())) {
            return false;
        }
        if (this.ownerId == null ? other.getOwnerId() != null : !this.ownerId.equals(other.getOwnerId())) {
            return false;
        }
        if (this.stepId == null ? other.getStepId() != null : !this.stepId.equals(other.getStepId())) {
            return false;
        }
        return this.type == other.getType();
    }

    public AttachmentKey getAttachmentKey() {
        return new AttachmentKey(this.type, this.ownerId, this.stepId, this.additionalId, this.fileName);
    }
}

