/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.calendar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Content {
    private String name;
    private Content parent;
    private ArrayList<Content> subContents = new ArrayList();
    private ArrayList<String> values = new ArrayList();
    private HashMap<String, String[]> attributes = new HashMap();

    protected Content(String name, Content parent) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.addSubContent(this);
        }
    }

    protected List<String> getValues(String name) {
        List<String> result = null;
        if (name.equals(this.name)) {
            return this.values;
        }
        for (Content subContent : this.subContents) {
            result = subContent.getValues(name);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    protected String[] get(String name, String key) {
        String[] result = null;
        if (name.equals(this.name)) {
            result = this.attributes.get(key);
            if (result == null) {
                result = new String[]{"", ""};
            }
            return result;
        }
        for (Content subContent : this.subContents) {
            result = subContent.get(name, key);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private void addSubContent(Content sub) {
        this.subContents.add(sub);
    }

    protected void appendLine(String line) {
        if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
            Object value = this.values.get(this.values.size() - 1);
            value = (String)value + line.substring(1);
            this.values.set(this.values.size() - 1, (String)value);
        } else {
            this.values.add(line);
        }
    }

    protected void refactor() {
        for (String param : this.values) {
            int pos = param.indexOf(58);
            if (pos == -1) {
                throw new IllegalArgumentException("Unexpected data! #" + param + "#");
            }
            String key = param.substring(0, pos);
            String value = param.substring(pos + 1);
            this.handle(key.split(";"), value);
        }
        for (Content subContent : this.subContents) {
            subContent.refactor();
        }
    }

    private void handle(String[] key, String value) {
        if (key.length < 1) {
            throw new IllegalArgumentException("Unexpected data!");
        }
        if ("DESCRIPTION".equals(key[0])) {
            value = value.replace("\\n", "\n");
            value = value.replace("\\,", ",");
        }
        String[] values = new String[]{key.length > 1 ? key[1] : "", value};
        this.attributes.put(key[0], values);
    }

    protected String getName() {
        return this.name;
    }

    protected Content getParent() {
        return this.parent;
    }
}

