/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.SuppressFBWarnings;

public class ChecksumUtils {
    private static final int BUFFER_SIZE = 2048;

    public static String computeChecksum(InputStream stream) throws IOException {
        try {
            return ChecksumUtils.getSHA1fromStream(stream);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Your Java runtime must support the SHA1 algorithm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_SHA1"}, justification="just for checksum, legacy code")
    private static String getSHA1fromStream(InputStream stream) throws IOException, NoSuchAlgorithmException {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] data = new byte[2048];
            int read = 0;
            while ((read = stream.read(data)) != -1) {
                sha1.update(data, 0, read);
            }
            String string = ChecksumUtils.bytesToHexString(sha1.digest());
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String bytesToHexString(byte[] bytes) {
        char[] hexCharArray = "0123456789ABCDEF".toCharArray();
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(hexCharArray[b >> 4 & 0xF]);
            sb.append(hexCharArray[b & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        int length = hexString.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("length of the hexString must be even: " + hexString);
        }
        byte[] result = new byte[length / 2];
        for (int index = 0; index < length; index += 2) {
            int h = ChecksumUtils.hexToDecimal(hexString.charAt(index));
            int l = ChecksumUtils.hexToDecimal(hexString.charAt(index + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("the hexString must not contain illegal characters: " + hexString);
            }
            result[index / 2] = (byte)(h * 16 + l);
        }
        return result;
    }

    private static int hexToDecimal(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }
}

