/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server;

import com.inet.helpdesk.core.data.ConnectionFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class AttachmentStatementProvider {
    private ThreadLocal<HashMap<String, PreparedStatement>> threadLocalStatementCache = new ThreadLocal();
    private ThreadLocal<Connection> threadLocalConnection = new ThreadLocal();
    private ConnectionFactory connectionFactory;
    private ConcurrentHashMap<PreparedStatement, Connection> pstmToConMap = new ConcurrentHashMap();

    public void setConnectionFactory(@Nonnull ConnectionFactory connectionFactory) {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("given connectionFactory must not be null");
        }
        this.connectionFactory = connectionFactory;
    }

    public void setConnection(@Nonnull Connection connection, boolean enableStatementCache) {
        if (connection == null) {
            throw new IllegalArgumentException("connection must not be null");
        }
        this.resetConnectionToNull();
        this.threadLocalConnection.set(connection);
        if (enableStatementCache && !this.isStatementCacheEnabled()) {
            this.threadLocalStatementCache.set(new HashMap());
        } else {
            this.threadLocalStatementCache.set(null);
        }
    }

    public void resetConnectionToNull() {
        if (this.isStatementCacheEnabled()) {
            for (PreparedStatement statement : this.threadLocalStatementCache.get().values()) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.threadLocalConnection.set(null);
        this.threadLocalStatementCache.set(null);
    }

    public boolean isStatementCacheEnabled() {
        return this.threadLocalStatementCache.get() != null && this.isConnectionSet();
    }

    public boolean isConnectionSet() {
        return this.threadLocalConnection.get() != null;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Internal API, caller must protect")
    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        if (this.isStatementCacheEnabled()) {
            return this.getPreparedStatementFromCache(sql);
        }
        if (this.isConnectionSet()) {
            return this.threadLocalConnection.get().prepareStatement(sql);
        }
        Connection connection = this.connectionFactory.getConnection();
        PreparedStatement pstm = connection.prepareStatement(sql);
        this.pstmToConMap.put(pstm, connection);
        return pstm;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Internal API, caller must protect")
    private PreparedStatement getPreparedStatementFromCache(String sql) throws SQLException {
        HashMap<String, PreparedStatement> statementCache = this.threadLocalStatementCache.get();
        PreparedStatement cachedStatement = statementCache.get(sql);
        if (cachedStatement != null) {
            return cachedStatement;
        }
        PreparedStatement newStatement = this.threadLocalConnection.get().prepareStatement(sql);
        statementCache.put(sql, newStatement);
        return newStatement;
    }

    public void closePreparedStatement(PreparedStatement pstm) {
        if (pstm == null || this.isStatementCacheEnabled()) {
            return;
        }
        try {
            Connection connection;
            try {
                pstm.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!this.isConnectionSet() && (connection = this.pstmToConMap.get(pstm)) != null) {
                this.pstmToConMap.remove(pstm);
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

