/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.shared;

import com.inet.annotations.JsonData;
import com.inet.editor.BaseEditor;
import com.inet.html.utils.EmbeddedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

@JsonData
public class AttachmentContent {
    private final File file;
    private final byte[] data;
    private final String fileName;
    private final long lastModified;
    private final long fileSize;
    private transient ImageEmbeddingData embeddedImage;
    private STATE currentState = STATE.INITIAL;

    public AttachmentContent(File file) {
        this.file = file;
        this.fileName = file.getName();
        this.lastModified = file.lastModified();
        this.fileSize = file.length();
        this.data = null;
    }

    public AttachmentContent(String fileName, byte[] data) {
        this.fileName = fileName;
        this.data = data;
        this.lastModified = System.currentTimeMillis();
        this.fileSize = data.length;
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() throws IOException {
        if (this.data != null) {
            return this.data;
        }
        try (FileInputStream fs = new FileInputStream(this.file);){
            byte[] fileContent = new byte[fs.available()];
            fs.read(fileContent);
            byte[] byArray = fileContent;
            return byArray;
        }
    }

    public boolean hasData() {
        return this.data != null || this.file != null && this.file.canRead();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isFileData() {
        return this.file != null && this.currentState != STATE.DELIVERED;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isContentAccessible() {
        return this.data != null || this.file != null && this.file.isFile();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public ImageEmbeddingData getImageData() {
        return this.embeddedImage;
    }

    public void setImageReference(EmbeddedImage imageReference, BaseEditor editor) {
        this.embeddedImage = new ImageEmbeddingData(imageReference, editor);
    }

    public STATE getState() {
        return this.currentState;
    }

    public void setState(STATE currentState) {
        this.currentState = currentState;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof AttachmentContent) {
            if (obj == this) {
                return true;
            }
            AttachmentContent compare = (AttachmentContent)obj;
            if (this.data != null && compare.data != null && this.data.length == compare.data.length) {
                for (int i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == compare.data[i]) continue;
                    return false;
                }
                return true;
            }
            if (this.file != null && compare.file != null) {
                return this.file.equals(compare.file);
            }
        }
        return false;
    }

    public static enum STATE {
        INITIAL,
        EXECUTING,
        DELIVERED,
        FAILED;

    }

    public class ImageEmbeddingData {
        private final EmbeddedImage imageReference;
        private final BaseEditor editor;

        private ImageEmbeddingData(EmbeddedImage imageReference, BaseEditor editor) {
            this.imageReference = imageReference;
            this.editor = editor;
        }

        public EmbeddedImage getImageReference() {
            return this.imageReference;
        }

        public BaseEditor getEditor() {
            return this.editor;
        }
    }
}

