/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.server.model;

import com.inet.annotations.JsonData;

@JsonData
public class AttachmentFileRow {
    private String checksum;
    private String directoryPath;
    private long fileLength;

    private AttachmentFileRow() {
    }

    public AttachmentFileRow(String checksum, String directoryPath, long fileLength) throws IllegalArgumentException {
        if (checksum == null || checksum.isEmpty()) {
            throw new IllegalArgumentException("checksum must not be null or empty");
        }
        if (directoryPath == null || directoryPath.isEmpty()) {
            throw new IllegalArgumentException("directoryPath must not be null or empty");
        }
        if (!directoryPath.startsWith("/") || !directoryPath.endsWith("/")) {
            throw new IllegalArgumentException("directoryPath must start and end with / character");
        }
        String dirPathWithoutOpeningAndClosingSlashes = directoryPath.substring(1, directoryPath.length() - 1);
        if (dirPathWithoutOpeningAndClosingSlashes.trim().isEmpty()) {
            throw new IllegalArgumentException("directoryPath must not contain only two / characters or two / characters with whitespace characters between");
        }
        if (fileLength < 0L) {
            throw new IllegalArgumentException("fileLength must not be negative");
        }
        this.checksum = checksum;
        this.directoryPath = directoryPath;
        this.fileLength = fileLength;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public String getFilePath() {
        return this.directoryPath + this.getFileName();
    }

    public String getFileName() {
        return AttachmentFileRow.getFileName(this.checksum, this.fileLength);
    }

    public static String getFileName(String checksum, long fileLength) throws IllegalArgumentException {
        if (checksum == null || checksum.isEmpty()) {
            throw new IllegalArgumentException("checksum must not be null or empty");
        }
        if (fileLength < 0L) {
            throw new IllegalArgumentException("fileLength must not be negative");
        }
        return checksum + fileLength;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.directoryPath == null ? 0 : this.directoryPath.hashCode());
        result = 31 * result + (int)(this.fileLength ^ this.fileLength >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentFileRow other = (AttachmentFileRow)obj;
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        if (this.directoryPath == null ? other.directoryPath != null : !this.directoryPath.equals(other.directoryPath)) {
            return false;
        }
        return this.fileLength == other.fileLength;
    }
}

