/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.attachments.shared;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentContent;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentOwnerType;
import com.inet.lib.util.EncodingFunctions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonData
public class AttachmentDescription
implements Cloneable {
    private String serverFilePath;
    private String fileDisplayName;
    private String fileExtension = "";
    private AttachmentContent data;
    private int stepId = -1;
    private long lastModified = System.currentTimeMillis();
    private long filesize;
    private Integer ticketId;
    private transient String physicalFilePath;
    private AttachmentOwnerType attachmentType = AttachmentOwnerType.TicketAttachment;

    public String getPrefixedNameWithExtension() {
        StringBuilder sb = new StringBuilder();
        if (this.ticketId != null && this.ticketId >= 1) {
            sb.append(this.ticketId);
        }
        if (this.stepId >= 0) {
            sb.append("_ReaID").append(this.stepId).append("_");
        } else if (sb.length() > 0) {
            sb.append("_");
        }
        sb.append(this.getFileName());
        return sb.toString();
    }

    public void setPrefixedNameWithExtension(String fileDisplayName) {
        if (fileDisplayName.matches("\\d+_ReaID\\d+_.*")) {
            p = Pattern.compile("(\\d+)_ReaID(\\d+)_.*");
            Matcher m = p.matcher(fileDisplayName);
            m.find();
            try {
                this.ticketId = Integer.valueOf(m.group(1));
                this.stepId = Integer.valueOf(m.group(2));
            }
            catch (NumberFormatException exc) {
                this.ticketId = null;
                this.stepId = -1;
            }
            int nameIndex = fileDisplayName.indexOf("_", fileDisplayName.indexOf("_") + 1) + 1;
            this.fileDisplayName = fileDisplayName.substring(nameIndex);
        } else if (fileDisplayName.matches("_ReaID\\d+_.*")) {
            p = Pattern.compile("_ReaID(\\d+)_.*");
            Matcher m = p.matcher(fileDisplayName);
            m.find();
            try {
                this.stepId = Integer.valueOf(m.group(1));
            }
            catch (NumberFormatException exc) {
                this.ticketId = null;
                this.stepId = -1;
            }
            int nameIndex = fileDisplayName.indexOf("_", fileDisplayName.indexOf("_") + 1) + 1;
            this.fileDisplayName = fileDisplayName.substring(nameIndex);
        } else if (fileDisplayName.matches("\\d+_.*")) {
            p = Pattern.compile("(\\d+)_.*");
            Matcher m = p.matcher(fileDisplayName);
            m.find();
            this.stepId = -1;
            try {
                this.ticketId = Integer.valueOf(m.group(1));
            }
            catch (NumberFormatException exc) {
                this.ticketId = null;
            }
            int nameIndex = fileDisplayName.indexOf("_") + 1;
            this.fileDisplayName = fileDisplayName.substring(nameIndex);
        } else {
            this.fileDisplayName = fileDisplayName;
        }
        int dotIndex = fileDisplayName.lastIndexOf(46);
        if (dotIndex > -1) {
            this.fileExtension = fileDisplayName.substring(dotIndex).toLowerCase();
        }
    }

    public void setFileName(String fileName) {
        this.fileDisplayName = fileName;
    }

    public String getFileName() {
        return this.fileDisplayName;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long filesize) {
        this.filesize = filesize;
    }

    @Deprecated
    public String getFilePath() {
        return this.serverFilePath;
    }

    public String getRESTfulFilePath() {
        return EncodingFunctions.encodeUrlPath((String)this.getRESTfulFilePathDecoded());
    }

    public String getRESTfulFilePathDecoded() {
        if (this.ticketId == null || this.ticketId <= 0) {
            return this.getFilePath();
        }
        String attachmentSubContext = this.attachmentType.getAttachmentSubContext();
        boolean containsStepId = this.stepId >= 0;
        StringBuilder builder = new StringBuilder();
        builder.append("Attachments/").append(attachmentSubContext).append("/").append(this.ticketId).append("/").append(containsStepId ? Integer.valueOf(this.stepId) : "").append(containsStepId ? "/" : "").append(this.getFileName());
        return builder.toString();
    }

    public void setFilePath(String filePath) {
        this.serverFilePath = filePath;
    }

    public Integer getOwnerId() {
        return this.ticketId;
    }

    public int getStepId() {
        return this.stepId;
    }

    public void setStepId(Integer stepId) {
        if (stepId == null) {
            throw new IllegalArgumentException("null not allowed - did you mean -1?");
        }
        this.stepId = stepId;
    }

    public void setOwnerId(Integer ticketId) {
        this.ticketId = ticketId;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getPrefixedNameWithoutExtension() {
        String prefixedNameWithExtension = this.getPrefixedNameWithExtension();
        int dotIndex = prefixedNameWithExtension.lastIndexOf(46);
        if (dotIndex > -1) {
            return prefixedNameWithExtension.substring(0, dotIndex);
        }
        return prefixedNameWithExtension;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String toString() {
        return this.getPrefixedNameWithExtension();
    }

    public AttachmentContent getData() {
        return this.data;
    }

    public void setData(AttachmentContent data) {
        this.data = data;
    }

    public AttachmentDescription clone() {
        AttachmentDescription clone = new AttachmentDescription();
        clone.serverFilePath = this.serverFilePath;
        clone.fileExtension = this.fileExtension;
        clone.data = this.data;
        clone.filesize = this.filesize;
        clone.fileDisplayName = this.fileDisplayName;
        clone.ticketId = this.ticketId;
        clone.stepId = this.stepId;
        clone.lastModified = this.lastModified;
        clone.attachmentType = this.attachmentType;
        return clone;
    }

    public int hashCode() {
        return this.serverFilePath != null ? this.serverFilePath.hashCode() : (this.fileDisplayName != null ? this.fileDisplayName.hashCode() : super.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AttachmentDescription)) {
            return false;
        }
        AttachmentDescription other = (AttachmentDescription)obj;
        if (this.serverFilePath != null ? !this.serverFilePath.equals(other.serverFilePath) : other.serverFilePath != null) {
            return false;
        }
        if (this.fileDisplayName != null ? !this.fileDisplayName.equals(other.fileDisplayName) : other.fileDisplayName != null) {
            return false;
        }
        if (this.ticketId != null ? !this.ticketId.equals(other.ticketId) : other.ticketId != null) {
            return false;
        }
        if (this.stepId != other.stepId) {
            return false;
        }
        return this.attachmentType.equals(other.attachmentType);
    }

    public boolean hasPendingContent() {
        return this.data != null && this.data.getState() != AttachmentContent.STATE.DELIVERED && this.data.hasData();
    }

    public String getPhysicalFilePath() {
        return this.physicalFilePath;
    }

    public void setPhysicalFilePath(String physicalFilePath) {
        this.physicalFilePath = physicalFilePath;
    }

    public void setAttachmentType(AttachmentOwnerType attachmentType) {
        if (attachmentType == null) {
            throw new IllegalArgumentException("attachment type must not be null");
        }
        this.attachmentType = attachmentType;
    }

    public AttachmentOwnerType getAttachmentType() {
        return this.attachmentType;
    }
}

