/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.PropertyInfo;

final class ObjectFormatter
implements Formatter {
    private Class<?> cls;
    private transient PropertyInfo[] props;

    public ObjectFormatter(Class<?> cls) {
        this.cls = cls;
    }

    @Override
    public boolean accept(Object o) {
        return o != null && !o.getClass().isPrimitive();
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        if (this.props == null) {
            this.props = ObjectFormatter.getGetProperties(context, this.cls);
        }
        out.append('{');
        int count = 0;
        String key = null;
        try {
            Class<?> lastClass = null;
            Formatter lastFormatter = null;
            for (PropertyInfo prop : this.props) {
                key = prop.getName();
                Object value = prop.get(o);
                if (value == src || context.isSuppressNull() && value == null) continue;
                if (count != 0) {
                    out.append(',');
                }
                if (context.isPrettyPrint()) {
                    out.append('\n');
                    context.appendIndent(out, context.getDepth() + 1);
                }
                StringFormatter.serialize(context, key.toString(), out);
                out.append(':');
                if (context.isPrettyPrint()) {
                    out.append(' ');
                }
                JSONHint hint = prop.getReadAnnotation(JSONHint.class);
                context.enter(key, hint);
                key = null;
                value = context.preformatInternal(prop.getReadGenericType(), value);
                if (value == null) {
                    NullFormatter.INSTANCE.format(context, src, value, out);
                } else if (hint == null) {
                    if (value.getClass() == lastClass) {
                        lastFormatter.format(context, src, value, out);
                    } else {
                        lastFormatter = context.formatInternal(value, out);
                        lastClass = value.getClass();
                    }
                } else {
                    context.formatInternal(value, out);
                }
                context.exit();
                ++count;
            }
        }
        catch (Exception e) {
            if (key != null) {
                context.enter(key, null);
            }
            throw e;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            context.appendIndent(out, context.getDepth());
        }
        out.append('}');
    }

    static PropertyInfo[] getGetProperties(JSON.Context context, Class<?> c) {
        int ordinal;
        String name;
        JSONHint hint;
        HashMap<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
        for (PropertyInfo prop : BeanInfo.get(c).getProperties()) {
            Field f = prop.getField();
            if (f == null || context.ignoreInternal(c, f)) continue;
            hint = f.getAnnotation(JSONHint.class);
            name = null;
            ordinal = prop.getOrdinal();
            if (hint != null) {
                if (hint.ignore()) continue;
                ordinal = hint.ordinal();
                if (hint.name().length() != 0) {
                    name = hint.name();
                }
            }
            if (name == null) {
                name = context.normalizeInternal(prop.getName());
                if (context.getPropertyStyle() != null) {
                    name = context.getPropertyStyle().to(name);
                }
            }
            if (!name.equals(prop.getName()) || ordinal != prop.getOrdinal() || f != prop.getReadMember()) {
                prop = new PropertyInfo(prop.getBeanClass(), name, prop.getField(), null, null, prop.isStatic(), ordinal);
            }
            if (prop.getReadMethod() != null) {
                prop.getReadMethod().setAccessible(true);
            } else if (prop.getField() != null) {
                prop.getField().setAccessible(true);
            }
            props.put(name, prop);
        }
        for (PropertyInfo prop : BeanInfo.get(c).getProperties()) {
            Method m = prop.getReadMethod();
            if (m == null || context.ignoreInternal(c, m)) continue;
            hint = m.getAnnotation(JSONHint.class);
            name = null;
            ordinal = prop.getOrdinal();
            if (hint != null) {
                if (hint.ignore()) continue;
                ordinal = hint.ordinal();
                if (hint.name().length() != 0) {
                    name = hint.name();
                }
            }
            if (name == null) {
                name = context.normalizeInternal(prop.getName());
                if (context.getPropertyStyle() != null) {
                    name = context.getPropertyStyle().to(name);
                }
            }
            if (!name.equals(prop.getName()) || ordinal != prop.getOrdinal()) {
                props.put(name, new PropertyInfo(prop.getBeanClass(), name, null, prop.getReadMethod(), null, prop.isStatic(), ordinal));
                continue;
            }
            props.put(name, prop);
        }
        Collection values = props.values();
        Object[] list = new PropertyInfo[values.size()];
        int i = 0;
        for (PropertyInfo pi : values) {
            list[i++] = pi;
        }
        Arrays.sort(list);
        return list;
    }
}

