/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.ai.structure;

import com.inet.config.ConfigKey;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.Encryption;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ai.AIServerPlugin;
import com.inet.plugin.ai.api.AIProviderStructureSetting;
import com.inet.plugin.ai.api.AIProviderType;
import com.inet.plugin.ai.api.AIRequest;
import com.inet.plugin.ai.api.Communicator;
import com.inet.plugin.ai.api.ResponseHandler;
import com.inet.plugin.ai.structure.g;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class c
extends AbstractStructureProvider {
    @Nonnull
    public static final ConfigKey AI_PROVIDERS = new ConfigKey("ai.providers", "[]", String.class);

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(103, "categorygroup.ai", this.translate(settings, "categorygroup.ai", new Object[0]), null));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.ai": {
                categories.add(new ConfigCategory(100, "category.ai.providers", this.translate(settings, "category.ai.providers", new Object[0]), "ai-integration.ai-connections"));
            }
        }
    }

    @Nullable
    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.ai.providers": {
                return ((Object)((Object)this)).getClass().getResource("ai_provider_48.svg");
            }
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.ai.providers": {
                configPropertyGroups.add(new ConfigPropertyGroup(100, "group.ai.providers", AIServerPlugin.MSG.getMsg("aiprovider.title", new Object[0])));
            }
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "group.ai.providers": {
                configProperties.add((ConfigProperty)this.a(settings));
            }
        }
    }

    @Nonnull
    private ItemListConfigProperty a(@Nonnull ConfigStructureSettings configStructureSettings) {
        ArrayList arrayList;
        Object object;
        String string = "ai-provider.action";
        try {
            object = configStructureSettings.getValue(AI_PROVIDERS);
            arrayList = (ArrayList)new Json().fromJson((String)object, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{HashMap.class}), new HashMap());
            arrayList.forEach(hashMap -> {
                hashMap.put("newlyCreated", "false");
                if (hashMap.get("apikey") != null) {
                    hashMap.put("apikey", Encryption.decrypt((String)((String)hashMap.get("apikey"))));
                }
            });
        }
        catch (Exception exception) {
            arrayList = new ArrayList();
        }
        object = ServerPluginManager.getInstance().get(AIProviderType.class);
        ArrayList<ConfigPropertyGroup> arrayList2 = new ArrayList<ConfigPropertyGroup>();
        arrayList2.add(new ConfigPropertyGroup(0, string));
        arrayList2.add(new ConfigPropertyGroup(1, "ACTION_CHECK_CONNECTION", AIServerPlugin.MSG.getMsg("ai.checkConnection", new Object[0]), new ConfigAction("ACTION_CHECK_CONNECTION", AIServerPlugin.MSG.getMsg("ai.checkConnection2", new Object[0]))));
        ArrayList<ConfigRowAction> arrayList3 = new ArrayList<ConfigRowAction>();
        ItemListConfigProperty itemListConfigProperty = object.iterator();
        while (itemListConfigProperty.hasNext()) {
            AIProviderStructureSetting aIProviderStructureSetting2;
            AIProviderType aIProviderType = (AIProviderType)itemListConfigProperty.next();
            HashMap hashMap2 = new HashMap();
            ArrayList arrayList4 = new ArrayList();
            this.addTo(arrayList4, "key", "Hidden", aIProviderType.getName(), configStructureSettings);
            this.addTo(arrayList4, "newlyCreated", "Hidden", "true", configStructureSettings);
            this.addTo(arrayList4, "displayname", "SimpleText", aIProviderType.getDisplayName(), configStructureSettings);
            List<AIProviderStructureSetting> list = aIProviderType.getConfigProperties();
            for (AIProviderStructureSetting aIProviderStructureSetting2 : list) {
                this.addTo(arrayList4, aIProviderStructureSetting2.getKey(), aIProviderStructureSetting2.getConfigPropertyType(), aIProviderStructureSetting2.getDefaultValue(), configStructureSettings);
            }
            hashMap2.put(string, arrayList4);
            hashMap2.put("ACTION_CHECK_CONNECTION", new ArrayList());
            ArrayList arrayList5 = new ArrayList();
            aIProviderStructureSetting2 = new ConfigCondition(ConfigCondition.Operation.Equals, new Object[]{"key", aIProviderType.getName()});
            ConfigAction configAction = new ConfigAction(string, aIProviderType.getDisplayName());
            ConditionGenerator conditionGenerator = new ConditionGenerator();
            ConfigCondition configCondition = conditionGenerator.createCondition().property("apikey").equals().value((Object)"");
            arrayList5.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().not(configCondition), "gptmodel"));
            ConfigCategory configCategory = new ConfigCategory(0, "ai-provider.action", aIProviderType.getDisplayName(), "ai-integration.ai-connections." + aIProviderType.getName().replace(" ", "-"));
            ConfigRowAction configRowAction = new ConfigRowAction(configAction, (ConfigCondition)aIProviderStructureSetting2, configCategory, arrayList2, hashMap2, arrayList5);
            configRowAction.setAddMultipleEntriesAllowed(true);
            arrayList3.add(configRowAction);
        }
        itemListConfigProperty = new ItemListConfigProperty(0, AI_PROVIDERS.getKey(), "ItemListAIProvider", (Object)arrayList, this.translate(configStructureSettings, "add", new Object[0]), arrayList3.toArray(new ConfigRowAction[arrayList3.size()]));
        itemListConfigProperty.setManuallySortable(true);
        return itemListConfigProperty;
    }

    @Nullable
    public List<LocalizedKey> getSelectValues(@Nonnull String key, String filter, ConfigStructureSettings settings) {
        if ("gptmodel".equals(key) && "GPT".equals(settings.getValue("key"))) {
            String string = settings.getValue("gptmodel");
            String string2 = settings.getValue("apikey");
            ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
            try {
                if (string2 != null && !string2.isBlank()) {
                    List<String> list = this.h(string2);
                    String string3 = filter == null ? "" : filter.toLowerCase();
                    for (String string4 : list) {
                        if (!string4.toLowerCase().contains(string3) || !string4.toLowerCase().startsWith("gpt") && !string4.toLowerCase().startsWith("o3") && !string4.toLowerCase().startsWith("o4") || string4.toLowerCase().contains("instruct") || string4.toLowerCase().contains("-202") || string4.toLowerCase().contains("realtime") || string4.toLowerCase().contains("audio") || string4.toLowerCase().contains("preview") || string4.toLowerCase().contains("image") || string4.toLowerCase().contains("transcribe") || string4.toLowerCase().contains("tts") || string4.toLowerCase().contains("embed")) continue;
                        arrayList.add(new LocalizedKey(string4, string4));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && !string.isBlank() && arrayList.stream().noneMatch(localizedKey -> localizedKey.getKey().equals(string))) {
                arrayList.add(0, new LocalizedKey(string, string));
            }
            return arrayList;
        }
        if ("gptmodel".equals(key) && "Claude".equals(settings.getValue("key"))) {
            String string = settings.getValue("gptmodel");
            String string5 = settings.getValue("apikey");
            ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
            try {
                if (string5 != null && !string5.isBlank()) {
                    List<String> list = this.i(string5);
                    String string6 = filter == null ? "" : filter.toLowerCase();
                    for (String string7 : list) {
                        if (!string7.toLowerCase().contains(string6)) continue;
                        arrayList.add(new LocalizedKey(string7, string7));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && !string.isBlank() && arrayList.stream().noneMatch(localizedKey -> localizedKey.getKey().equals(string))) {
                arrayList.add(0, new LocalizedKey(string, string));
            }
            return arrayList;
        }
        if ("gptmodel".equals(key) && "Gemini".equals(settings.getValue("key"))) {
            String string = settings.getValue("gptmodel");
            String string8 = settings.getValue("apikey");
            ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
            try {
                if (string8 != null && !string8.isBlank()) {
                    List<String> list = this.j(string8);
                    String string9 = filter == null ? "" : filter.toLowerCase();
                    for (String string10 : list) {
                        if (!string10.toLowerCase().contains(string9) || !string10.toLowerCase().startsWith("gemini") || string10.toLowerCase().contains("instruct") || string10.toLowerCase().contains("realtime") || string10.toLowerCase().contains("audio") || string10.toLowerCase().contains("preview") || string10.toLowerCase().contains("image") || string10.toLowerCase().contains("transcribe") || string10.toLowerCase().contains("tts") || string10.toLowerCase().contains("embed")) continue;
                        arrayList.add(new LocalizedKey(string10, string10));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && !string.isBlank() && arrayList.stream().noneMatch(localizedKey -> localizedKey.getKey().equals(string))) {
                arrayList.add(0, new LocalizedKey(string, string));
            }
            return arrayList;
        }
        return super.getSelectValues(key, filter, settings);
    }

    @Nonnull
    List<String> h(@Nonnull String string) throws IOException {
        InputStream inputStream;
        URL uRL = new URL("https://api.openai.com/v1/models");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("Authorization", "Bearer " + string);
        httpURLConnection.setDoOutput(false);
        int n2 = httpURLConnection.getResponseCode();
        InputStream inputStream2 = inputStream = n2 >= 200 && n2 < 300 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        if (inputStream == null) {
            return new ArrayList<String>();
        }
        String string2 = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        HashMap hashMap = (HashMap)new Json().fromJson(string2, HashMap.class);
        Object v = hashMap.get("data");
        if (!(v instanceof List)) {
            return new ArrayList<String>();
        }
        List list = (List)v;
        List list2 = list.stream().sorted(new Comparator<HashMap<String, Object>>(){

            public int a(HashMap<String, Object> hashMap, HashMap<String, Object> hashMap2) {
                return ((Integer)hashMap2.get("created")).compareTo((Integer)hashMap.get("created"));
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((HashMap)object, (HashMap)object2);
            }
        }).collect(Collectors.toList());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HashMap hashMap2 : list2) {
            Object v2;
            if (hashMap2 == null || !((v2 = hashMap2.get("id")) instanceof String) || ((String)v2).isBlank()) continue;
            arrayList.add((String)v2);
        }
        return arrayList;
    }

    @Nonnull
    List<String> i(@Nonnull String string) throws IOException {
        InputStream inputStream;
        URL uRL = new URL("https://api.anthropic.com/v1/models");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("x-api-key", string);
        httpURLConnection.setRequestProperty("anthropic-version", "2023-06-01");
        httpURLConnection.setDoOutput(false);
        int n2 = httpURLConnection.getResponseCode();
        InputStream inputStream2 = inputStream = n2 >= 200 && n2 < 300 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        if (inputStream == null) {
            return new ArrayList<String>();
        }
        String string2 = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        HashMap hashMap = (HashMap)new Json().fromJson(string2, HashMap.class);
        Object v = hashMap.get("data");
        if (!(v instanceof List)) {
            return new ArrayList<String>();
        }
        List list = (List)v;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HashMap hashMap2 : list) {
            Object v2;
            if (hashMap2 == null || !((v2 = hashMap2.get("id")) instanceof String) || ((String)v2).isBlank()) continue;
            arrayList.add((String)v2);
        }
        return arrayList;
    }

    @Nonnull
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="fix hardcoded URL")
    List<String> j(@Nonnull String string) throws IOException {
        InputStream inputStream;
        URL uRL = new URL("https://generativelanguage.googleapis.com/v1beta/models?key=" + string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setDoOutput(false);
        int n2 = httpURLConnection.getResponseCode();
        InputStream inputStream2 = inputStream = n2 >= 200 && n2 < 300 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        if (inputStream == null) {
            return new ArrayList<String>();
        }
        String string2 = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        HashMap hashMap = (HashMap)new Json().fromJson(string2, HashMap.class);
        Object v = hashMap.get("models");
        if (!(v instanceof List)) {
            return new ArrayList<String>();
        }
        List list = (List)v;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HashMap hashMap2 : list) {
            Object object;
            if (hashMap2 == null || !((object = hashMap2.get("name")) instanceof String) || ((String)object).isBlank()) continue;
            if (((String)object).startsWith("models/")) {
                object = ((String)object).substring("models/".length());
            }
            arrayList.add((String)object);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        if ("ai-provider.action".equals(categoryKey)) {
            List list;
            ConfigValidator configValidator = new ConfigValidator(messages, settings);
            if ("true".equals(settings.getValue("newlyCreated"))) {
                try {
                    String string = settings.getValue(AI_PROVIDERS);
                    list = (ArrayList)new Json().fromJson(string, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{HashMap.class}), new HashMap());
                }
                catch (Exception exception) {
                    list = new ArrayList();
                }
                if (list.stream().anyMatch(hashMap -> hashMap.getOrDefault("displayname", "").equals(settings.getValue("displayname")))) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, AIServerPlugin.MSG.getMsg("ai.duplicatename", new Object[0]), "displayname"));
                }
            }
            configValidator.checkNotEmpty("displayname");
            list = ServerPluginManager.getInstance().get(AIProviderType.class);
            for (AIProviderType aIProviderType : list) {
                if (!aIProviderType.getName().equals(settings.getValue("key"))) continue;
                aIProviderType.validate(configValidator, messages, settings);
                break;
            }
        } else if ("category.ai.providers".equals(categoryKey)) {
            ArrayList arrayList;
            try {
                String string = settings.getValue(AI_PROVIDERS);
                arrayList = (ArrayList)new Json().fromJson(string, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{HashMap.class}), new HashMap());
            }
            catch (Exception exception) {
                arrayList = new ArrayList();
            }
            if (arrayList.stream().map(hashMap -> hashMap.getOrDefault("displayname", "").toLowerCase()).distinct().count() < (long)arrayList.size()) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, AIServerPlugin.MSG.getMsg("ai.duplicatename", new Object[0]), AI_PROVIDERS));
            }
        }
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        switch (key) {
            case "ai.providers": {
                Json json = new Json();
                JsonParameterizedType jsonParameterizedType = new JsonParameterizedType(ArrayList.class, new Type[]{HashMap.class});
                ArrayList arrayList = (ArrayList)json.fromJson(value, (Type)jsonParameterizedType, new HashMap());
                arrayList = arrayList.stream().peek(hashMap -> {
                    String string = (String)hashMap.get("apikey");
                    if (string != null && !string.isBlank()) {
                        hashMap.put("apikey", Encryption.encrypt((String)string));
                    }
                }).collect(Collectors.toCollection(ArrayList::new));
                value = json.toJson((Object)arrayList);
                settings.save(AI_PROVIDERS, value);
                return ConfigStructure.SaveState.SAVE;
            }
        }
        return super.save(key, value, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action(@Nonnull String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
        if (actionKey.equals("ACTION_CHECK_CONNECTION")) {
            g g2 = new g();
            Object object = new Object();
            ResponseHandler responseHandler = aIResponse -> {
                if (aIResponse.getResponseText() != null && !aIResponse.getResponseText().isEmpty()) {
                    if (g2.u()) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Valid, this.translate(settings, "ai.connected", new Object[0]), ""));
                    } else {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Warning, this.translate(settings, "ai.connected_no_tool", new Object[0]), ""));
                    }
                } else {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "ai.notconnection", new Object[]{aIResponse.getErrorText()}), ""));
                }
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            };
            Object object2 = object;
            synchronized (object2) {
                List list = ServerPluginManager.getInstance().get(AIProviderType.class);
                for (AIProviderType aIProviderType : list) {
                    if (!aIProviderType.getName().equals(settings.getValue("key"))) continue;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    Properties properties = settings.getValues();
                    if (properties == null) continue;
                    for (String object32 : properties.stringPropertyNames()) {
                        hashMap.put(object32, settings.getValue(object32));
                    }
                    Communicator communicator = aIProviderType.createCommunicator(hashMap);
                    AIRequest aIRequest = new AIRequest("configuration", "Please call the connection_test tool once and only once to verify the connection. Then say DONE.", responseHandler, null, List.of(g2));
                    aIRequest.setForceTool(true);
                    aIRequest.setStreaming(true);
                    aIRequest.setStreamHandler(streamChunk -> {});
                    communicator.runRequest(aIRequest);
                    break;
                }
                try {
                    object.wait(this.r());
                }
                catch (InterruptedException interruptedException) {
                    AIServerPlugin.LOGGER.error((Throwable)interruptedException);
                }
                if (messages.isEmpty()) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "ai.timeout", new Object[0]), ""));
                }
            }
        }
    }

    protected long r() {
        return 30000L;
    }
}

