/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.ai.api;

import com.inet.annotations.InternalApi;
import com.inet.plugin.ai.api.AIToolException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public interface AITool {
    @Nonnull
    public String getName();

    @Nonnull
    public String getDescription();

    @Nonnull
    public @Nonnull List<@Nonnull ParameterDescription> getRequiredParameters();

    @Nonnull
    public @Nonnull List<@Nonnull ParameterDescription> getOptionalParameters();

    @Nullable
    public Object call(@Nonnull Map<String, Object> var1) throws AIToolException;

    @InternalApi
    public static final class ParameterType
    extends Enum<ParameterType> {
        public static final /* enum */ ParameterType integer = new ParameterType();
        public static final /* enum */ ParameterType number = new ParameterType();
        public static final /* enum */ ParameterType string = new ParameterType();
        public static final /* enum */ ParameterType bool = new ParameterType();
        public static final /* enum */ ParameterType nulltype = new ParameterType();
        public static final /* enum */ ParameterType object = new ParameterType();
        public static final /* enum */ ParameterType intarray = new ParameterType();
        public static final /* enum */ ParameterType numberarray = new ParameterType();
        public static final /* enum */ ParameterType stringarray = new ParameterType();
        public static final /* enum */ ParameterType boolarray = new ParameterType();
        public static final /* enum */ ParameterType objectarray = new ParameterType();
        private static final /* synthetic */ ParameterType[] J;

        public static ParameterType[] values() {
            return (ParameterType[])J.clone();
        }

        public static ParameterType valueOf(String name) {
            return Enum.valueOf(ParameterType.class, name);
        }

        public boolean isArray() {
            return switch (this) {
                case intarray, numberarray, stringarray, boolarray, objectarray -> true;
                default -> false;
            };
        }

        public String getTypeName() {
            return switch (this) {
                case intarray, integer -> "integer";
                case numberarray, number -> "number";
                case stringarray, string -> "string";
                case boolarray, bool -> "boolean";
                case nulltype -> "null";
                case objectarray, object -> "object";
                default -> "string";
            };
        }

        private static /* synthetic */ ParameterType[] b() {
            return new ParameterType[]{integer, number, string, bool, nulltype, object, intarray, numberarray, stringarray, boolarray, objectarray};
        }

        static {
            J = ParameterType.b();
        }
    }

    @InternalApi
    public static final class ParameterDescription
    extends Record {
        @Nonnull
        private final String D;
        @Nonnull
        private final String E;
        @Nonnull
        private final ParameterType F;
        private final @Nullable List<@Nonnull ParameterDescription> G;
        private final @Nullable List<@Nonnull ParameterDescription> H;
        private final Object @Nullable [] I;

        public ParameterDescription(@Nonnull String name, @Nonnull String description, @Nonnull ParameterType type, @Nullable List<@Nonnull ParameterDescription> requiredParams, @Nullable List<@Nonnull ParameterDescription> optionalParams) {
            this(name, description, type, requiredParams, optionalParams, null);
        }

        public ParameterDescription(@Nonnull String name, @Nonnull String description, @Nonnull ParameterType type) {
            this(name, description, type, null, null, null);
        }

        public ParameterDescription(@Nonnull String name, @Nonnull String description, @Nonnull ParameterType type, Object @Nullable [] values) {
            this(name, description, type, null, null, values);
        }

        public ParameterDescription(@Nonnull String name, @Nonnull String description, @Nonnull ParameterType type, @Nullable List<@Nonnull ParameterDescription> requiredParams, @Nullable List<@Nonnull ParameterDescription> optionalParams, Object @Nullable [] values) {
            this.D = name;
            this.E = description;
            this.F = type;
            this.G = requiredParams;
            this.H = optionalParams;
            this.I = values;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ParameterDescription.class, "name;description;type;requiredParams;optionalParams;values", "D", "E", "F", "G", "H", "I"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ParameterDescription.class, "name;description;type;requiredParams;optionalParams;values", "D", "E", "F", "G", "H", "I"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ParameterDescription.class, "name;description;type;requiredParams;optionalParams;values", "D", "E", "F", "G", "H", "I"}, this, o);
        }

        @Nonnull
        public String name() {
            return this.D;
        }

        @Nonnull
        public String description() {
            return this.E;
        }

        @Nonnull
        public ParameterType type() {
            return this.F;
        }

        public @Nullable List<@Nonnull ParameterDescription> requiredParams() {
            return this.G;
        }

        public @Nullable List<@Nonnull ParameterDescription> optionalParams() {
            return this.H;
        }

        public Object @Nullable [] values() {
            return this.I;
        }
    }
}

