/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.ai.api;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKey;
import com.inet.plugin.ai.AIServerPlugin;
import com.inet.plugin.ai.api.AIProviderType;
import com.inet.plugin.ai.api.Communicator;
import com.inet.plugin.ai.structure.a;
import com.inet.plugin.ai.structure.c;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class AIProviderManager {
    @Nonnull
    public static final ConfigKey AI_PROVIDERS = c.AI_PROVIDERS;
    private a h;

    public static AIProviderManager getInstance() {
        return AIServerPlugin.AI_MANAGER_INSTANCE;
    }

    public AIProviderManager(a accessor) {
        this.h = accessor;
    }

    @Nonnull
    public List<AIProviderType> getAllAIProviders() {
        ArrayList<HashMap<String, String>> arrayList = this.h.getAllAIProviderProps();
        return arrayList.stream().map(hashMap -> this.h.g((HashMap<String, String>)hashMap)).collect(Collectors.toList());
    }

    @Nullable
    public AIProviderType getDefaultAIProvider() {
        ArrayList<HashMap<String, String>> arrayList = this.h.getAllAIProviderProps();
        if (arrayList.isEmpty()) {
            return null;
        }
        return this.h.g(arrayList.get(0));
    }

    public ArrayList<HashMap<String, String>> getAllAIProviderProps() {
        return this.h.getAllAIProviderProps();
    }

    @Nullable
    public Communicator getDefaultCommunicator() {
        AIProviderType aIProviderType = this.getDefaultAIProvider();
        if (aIProviderType == null) {
            return null;
        }
        return aIProviderType.createCommunicator((Map<String, String>)this.getAllAIProviderProps().get(0));
    }

    @Nullable
    public Communicator getCommunicator(@Nullable String providerName) {
        if (providerName == null) {
            return null;
        }
        HashMap<String, String> hashMap = null;
        for (HashMap<String, String> hashMap2 : this.getAllAIProviderProps()) {
            if (!providerName.equals(hashMap2.get("displayname"))) continue;
            hashMap = hashMap2;
            break;
        }
        if (hashMap == null) {
            return null;
        }
        Object object = null;
        for (AIProviderType aIProviderType : this.getAllAIProviders()) {
            String string = (String)hashMap.get("key");
            if (string == null || !string.equals(aIProviderType.getName())) continue;
            object = aIProviderType;
            break;
        }
        if (object == null) {
            return null;
        }
        return object.createCommunicator((Map<String, String>)hashMap);
    }
}

