/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.ai.structure;

import com.inet.config.ConfigKey;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.LocalizedKeyListFactory;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ai.AIServerPlugin;
import com.inet.plugin.ai.structure.c;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class d
extends AbstractStructureProvider {
    public static final ConfigKey aU = new ConfigKey("chatgpt.spamfilterprompt", "We are a company providing customer support to our customers.", String.class);
    public static final ConfigKey aV = new ConfigKey("chatgpt.spamfilterprompt.active", "false", Boolean.class);
    public static final ConfigKey aW = new ConfigKey("chatgpt.spamfilterprompt.resource.id", "0", Integer.class);
    public static final ConfigKey aX = new ConfigKey("chatgpt.spamfilterprompt.priority.id", "0", Integer.class);
    public static final ConfigKey aY = new ConfigKey("chatgpt.spamfilterprompt.action", "chatgpt.spamfilterprompt.delete", String.class);

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(103, "categorygroup.ai", this.translate(settings, "categorygroup.ai", new Object[0]), null));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.ai": {
                categories.add(new ConfigCategory(200, "category.ai.spamfilter", this.translate(settings, "category.ai.spamfilter", new Object[0]), "ai-integration.spamfilter"));
            }
        }
    }

    @Nullable
    public URL getCategoryIcon(@Nonnull String categoryKey) {
        if ("category.ai.spamfilter".equals(categoryKey)) {
            return ((Object)((Object)this)).getClass().getResource("ai_spamfilter_48.svg");
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if ("category.ai.spamfilter".equals(categoryKey)) {
            configPropertyGroups.add(new ConfigPropertyGroup(100, "group.ai.spamfilter", AIServerPlugin.MSG.getMsg("spamfilter.group.title", new Object[0])));
        }
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        if ("group.ai.spamfilter".equals(propertyGroupKey)) {
            this.addTo(configProperties, "GPTSpam.left", "KeyLabel", this.translate(settings, "GPTSpam.label", new Object[0]), settings);
            this.addTo(configProperties, aV, settings);
            this.addTo(configProperties, new ConfigKey("spam.aiprovider"), "SelectEdit", settings, "");
            ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
            arrayList.add(new LocalizedKey("chatgpt.spamfilterprompt.delete", AIServerPlugin.MSG.getMsg("chatgpt.spamfilterprompt.delete", new Object[0])));
            arrayList.add(new LocalizedKey("chatgpt.spamfilterprompt.resource", AIServerPlugin.MSG.getMsg("chatgpt.spamfilterprompt.resource", new Object[0])));
            arrayList.add(new LocalizedKey("chatgpt.spamfilterprompt.priority", AIServerPlugin.MSG.getMsg("chatgpt.spamfilterprompt.priority", new Object[0])));
            this.addSelectTo(configProperties, aY, settings, arrayList);
            List<LocalizedKey> list = this.s();
            SelectConfigProperty selectConfigProperty = new SelectConfigProperty(401, aW.getKey(), "FixNumber", AIServerPlugin.MSG.getMsg(aW.getKey(), new Object[0]), (Object)settings.getValue(aW.getKey()), "", list);
            configProperties.add((ConfigProperty)selectConfigProperty);
            List<LocalizedKey> list2 = this.t();
            SelectConfigProperty selectConfigProperty2 = new SelectConfigProperty(402, aX.getKey(), "FixNumber", AIServerPlugin.MSG.getMsg(aX.getKey(), new Object[0]), (Object)settings.getValue(aX.getKey()), "", list2);
            configProperties.add((ConfigProperty)selectConfigProperty2);
            this.addTo(configProperties, aU, settings);
        }
    }

    protected List<LocalizedKey> s() {
        return LocalizedKeyListFactory.getResources();
    }

    protected List<LocalizedKey> t() {
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        List list = LocalizedKeyListFactory.getPriorities((ConnectionFactory)connectionFactory);
        return list;
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        if (!"category.ai.spamfilter".equals(categoryKey)) {
            return;
        }
        if ("true".equals(settings.getValue(aV))) {
            if ("chatgpt.spamfilterprompt.resource".equals(settings.getValue(aY))) {
                GUID gUID;
                String string = settings.getValue(aW);
                if (string != null && (gUID = HDUsersAndGroups.getResourceGroupUUID((int)Integer.valueOf(string))) != null) {
                    return;
                }
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, AIServerPlugin.MSG.getMsg("GPTSpam.needVal", new Object[0]), aW));
            } else if ("chatgpt.spamfilterprompt.priority".equals(settings.getValue(aY))) {
                String string = settings.getValue(aX);
                if (string != null) {
                    Integer n = Integer.valueOf(string);
                    PriorityVO priorityVO = (PriorityVO)PriorityManager.getInstance().get(n.intValue());
                    if (priorityVO != null && !priorityVO.isDeleted()) {
                        return;
                    }
                }
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, AIServerPlugin.MSG.getMsg("GPTSpam.needVal", new Object[0]), aX));
            }
        }
    }

    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        ConditionGenerator conditionGenerator = new ConditionGenerator();
        if ("category.ai.spamfilter".equals(categoryKey)) {
            ConfigCondition configCondition = conditionGenerator.createCondition().property(aV).equals().value((Object)"true");
            actions.add(conditionGenerator.enableActionFor(configCondition, "spam.aiprovider"));
            actions.add(conditionGenerator.enableActionFor(configCondition, aU));
            actions.add(conditionGenerator.enableActionFor(configCondition, aY));
            ConfigCondition configCondition2 = conditionGenerator.createCondition().property(aY).equals().value((Object)"chatgpt.spamfilterprompt.resource");
            actions.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{configCondition, configCondition2}), aW));
            ConfigCondition configCondition3 = conditionGenerator.createCondition().property(aY).equals().value((Object)"chatgpt.spamfilterprompt.priority");
            actions.add(conditionGenerator.visibleActionFor(conditionGenerator.createCondition().and(new ConfigCondition[]{configCondition, configCondition3}), aX));
        }
    }

    @Nullable
    public List<LocalizedKey> getSelectValues(@Nonnull String key, String filter, ConfigStructureSettings settings) {
        ArrayList arrayList;
        if (!"aiprovider".equals(key)) {
            return super.getSelectValues(key, filter, settings);
        }
        try {
            String string = settings.getValue(c.AI_PROVIDERS);
            arrayList = (ArrayList)new Json().fromJson(string, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{HashMap.class}), new HashMap());
        }
        catch (Exception exception) {
            arrayList = new ArrayList();
        }
        return arrayList.stream().map(hashMap -> new LocalizedKey((String)hashMap.get("displayname"), (String)hashMap.get("displayname"))).collect(Collectors.toList());
    }
}

