/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.ai.reporting;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigValue;
import com.inet.plugin.ai.AIServerPlugin;
import com.inet.plugin.ai.api.Communicator;
import com.inet.plugin.ai.structure.a;
import com.inet.plugin.ai.structure.c;
import com.inet.report.formula.UserDefinedFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;

@InternalApi
public class AIUserDefinedFunction
implements UserDefinedFunction {
    private static final ConfigValue<String> aJ = new ConfigValue(c.AI_PROVIDERS);
    private final a h;

    public AIUserDefinedFunction(a accessor) {
        this.h = accessor;
    }

    public String gpt(String query) {
        ArrayList<HashMap<String, String>> arrayList = this.p();
        String string = (String)arrayList.stream().filter(hashMap -> "GPT".equals(hashMap.get("key"))).findFirst().orElseThrow(() -> new IllegalStateException("reporting.nogpt")).get("displayname");
        return this.ai(query, string);
    }

    private ArrayList<HashMap<String, String>> p() {
        ArrayList<HashMap<String, String>> arrayList = this.h.getAllAIProviderProps();
        if (arrayList.isEmpty()) {
            throw new IllegalStateException(AIServerPlugin.MSG.getMsg("reporting.noprovider", new Object[0]));
        }
        return arrayList;
    }

    public String ai(String query) {
        ArrayList<HashMap<String, String>> arrayList = this.p();
        return this.ai(query, arrayList.get(0).get("displayname"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ai(String query, String aiConnectionProvider) {
        AtomicReference atomicReference;
        HashMap<String, String> hashMap = this.h.g(aiConnectionProvider);
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference2) {
            Communicator communicator = this.h.g(hashMap).createCommunicator(hashMap);
            communicator.runRequest("reporting", query, aIResponse -> {
                if (aIResponse.getErrorText() != null) {
                    AIServerPlugin.LOGGER.error((Object)("Error running formula GPT query: " + aIResponse.getErrorText()));
                } else {
                    atomicReference.set(aIResponse.getResponseText());
                }
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    atomicReference.notifyAll();
                }
            });
            try {
                atomicReference.wait(20000L);
                if (atomicReference.get() == null) {
                    AIServerPlugin.LOGGER.warn((Object)"Formula GPT query result not set.");
                }
                return (String)atomicReference.get();
            }
            catch (InterruptedException interruptedException) {
                AIServerPlugin.LOGGER.warn((Object)interruptedException);
            }
        }
        return "";
    }
}

