/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.ai.api;

import com.inet.annotations.PublicApi;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ai.api.AITool;
import com.inet.plugin.ai.api.ConversationStep;
import com.inet.plugin.ai.api.ConversationStepType;
import com.inet.plugin.ai.api.ResponseHandler;
import com.inet.plugin.ai.api.StreamChunk;
import com.inet.plugin.ai.api.ToolStreamChunk;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class AIRequest {
    private String k;
    @Nonnull
    private String l;
    @Nonnull
    private final ResponseHandler m;
    @Nonnull
    private final List<ConversationStep> n;
    private boolean o = true;
    @Nullable
    private final List<AITool> p;
    @Nullable
    private String q;
    private boolean r;
    private int s = 5;
    private boolean t;
    private boolean u;
    private Consumer<StreamChunk> v;
    @Nullable
    private List<String> w;
    @Nullable
    private Consumer<ToolStreamChunk> x;

    public AIRequest(@Nonnull String category, @Nonnull String userText, @Nonnull ResponseHandler responseHandler, @Nullable List<ConversationStep> previousConversation, @Nullable List<@Nonnull AITool> toolsToUse) {
        this.k = category;
        this.l = userText;
        this.m = responseHandler;
        this.n = previousConversation != null ? previousConversation : new ArrayList();
        this.p = toolsToUse;
        previousConversation = this.n;
        if (previousConversation.isEmpty() || !StringFunctions.isEmpty((String)userText) || ((ConversationStep)previousConversation.get(previousConversation.size() - 1)).getStepType() != ConversationStepType.tool) {
            previousConversation.add(new ConversationStep(userText, ConversationStepType.user));
        }
    }

    @Nonnull
    public String getUserText() {
        return this.l;
    }

    @Nonnull
    public ResponseHandler getResponseHandler() {
        return this.m;
    }

    @Nonnull
    public List<ConversationStep> getPreviousConversation() {
        return this.n;
    }

    public boolean isLimitedToProvidedTools() {
        return this.o;
    }

    public void setLimitedToProvidedTools(boolean limitedToProvidedTools) {
        this.o = limitedToProvidedTools;
    }

    @Nullable
    public List<AITool> getToolsToUse() {
        return this.p;
    }

    @Nullable
    public String getSystemPrompt() {
        return this.q;
    }

    public void setSystemPrompt(@Nullable String systemPrompt) {
        this.q = systemPrompt;
    }

    public boolean isForceTool() {
        return this.r;
    }

    public void setForceTool(boolean forceTool) {
        this.r = forceTool;
    }

    public void setMaximumToolCalls(int toolCalls) {
        this.s = toolCalls;
    }

    public int getMaximumToolCalls() {
        return this.s;
    }

    public void setPreviousConversation(List<ConversationStep> previousConversation) {
        this.n.clear();
        this.n.addAll(previousConversation);
    }

    public String getCategory() {
        return this.k;
    }

    @Nullable
    public Consumer<ToolStreamChunk> getToolStreamHandler() {
        return this.x;
    }

    public void setToolStreamHandler(@Nullable Consumer<ToolStreamChunk> handler) {
        this.x = handler;
    }

    public boolean isStreaming() {
        return this.t;
    }

    public void setStreaming(boolean streaming) {
        this.t = streaming;
    }

    public Consumer<StreamChunk> getStreamHandler() {
        return this.v;
    }

    public void setStreamHandler(Consumer<StreamChunk> handler) {
        this.v = handler;
    }

    public void setUserText(String userText) {
        this.l = userText;
    }

    @Nullable
    public List<String> getResourceIds() {
        return this.w;
    }

    public void setResourceIds(@Nullable List<String> resourceIds) {
        this.w = resourceIds;
    }

    public void cancel() {
        this.u = true;
    }

    public boolean isCanceled() {
        return this.u;
    }
}

