/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.webgui.handler.data;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.report.adhoc.server.api.common.AbstractDefinition;
import com.inet.report.adhoc.server.api.model.AdHocReport;
import com.inet.report.adhoc.server.api.model.AdHocReportPage;
import com.inet.report.adhoc.server.api.renderer.AdHocDefinition;
import com.inet.report.adhoc.webgui.controls.ComponentSettings;
import com.inet.report.adhoc.webgui.handler.data.AdHocComponent;
import com.inet.report.adhoc.webgui.handler.data.AdHocPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonData
public class AdHocReportDescription {
    private String theme;
    private String layout;
    private boolean landscape;
    private List<AdHocPage> pages;
    private Map<@Nonnull GUID, @Nonnull AdHocComponent> components;
    private AdHocComponent pageHeader;

    private AdHocReportDescription() {
    }

    public AdHocReportDescription(String theme, String layout, boolean landscape, AdHocComponent pageHeader, List<AdHocPage> pages, Map<@Nonnull GUID, @Nonnull AdHocComponent> components) {
        this.theme = theme;
        this.layout = layout;
        this.landscape = landscape;
        this.pageHeader = pageHeader;
        this.pages = pages;
        this.components = components;
    }

    public String getLayout() {
        return this.layout;
    }

    public List<AdHocPage> getPages() {
        return this.pages;
    }

    public Map<@Nonnull GUID, @Nonnull AdHocComponent> getComponents() {
        return this.components;
    }

    public AdHocComponent getPageHeader() {
        return this.pageHeader;
    }

    public String getTheme() {
        return this.theme;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    @Nonnull
    public AdHocReport convertToAdHocReport() {
        ArrayList<AdHocReportPage> arrayList = new ArrayList<AdHocReportPage>();
        for (AdHocPage adHocPage : this.pages) {
            ArrayList<AdHocDefinition> arrayList2 = new ArrayList<AdHocDefinition>();
            for (GUID gUID : adHocPage.getComponentIds()) {
                AdHocComponent adHocComponent = this.components.get(gUID);
                if (adHocComponent == null) continue;
                arrayList2.add(ComponentSettings.toServerModel(gUID, adHocComponent.getComponentType(), adHocComponent.getProperties(), false));
            }
            arrayList.add(new AdHocReportPage(arrayList2));
        }
        AdHocDefinition adHocDefinition = ComponentSettings.toServerModel(this.pageHeader.getComponentId(), this.pageHeader.getComponentType(), this.pageHeader.getProperties(), false);
        return new AdHocReport(StringFunctions.isEmpty((String)this.theme) ? null : this.theme, this.layout, this.landscape, adHocDefinition, arrayList);
    }

    @Nonnull
    public static AdHocReportDescription from(AdHocReport report) {
        HashMap<@Nonnull GUID, @Nonnull AdHocComponent> hashMap = new HashMap<GUID, AdHocComponent>();
        ArrayList<AdHocPage> arrayList = new ArrayList<AdHocPage>();
        for (AdHocReportPage object2 : report.getPages()) {
            ArrayList<GUID> arrayList2 = new ArrayList<GUID>();
            for (AdHocDefinition adHocDefinition : object2.getDefinitions()) {
                Map<String, String> map = ComponentSettings.toUiModel(adHocDefinition);
                GUID gUID = adHocDefinition.getComponentId();
                hashMap.put(gUID, new AdHocComponent(gUID, adHocDefinition.getExtensionName(), map));
                arrayList2.add(gUID);
            }
            arrayList.add(new AdHocPage(arrayList2));
        }
        Object object3 = report.getPageHeader();
        if (object3 == null) {
            object3 = new AdHocDefinition(GUID.generateNew(), "pageheader", Map.of());
        }
        AdHocComponent adHocComponent = new AdHocComponent(((AdHocDefinition)object3).getComponentId(), ((AbstractDefinition)object3).getExtensionName(), ComponentSettings.toUiModel((AdHocDefinition)object3));
        return new AdHocReportDescription(report.getTheme() == null ? "" : report.getTheme(), report.getLayout(), report.isLandscape(), adHocComponent, arrayList, hashMap);
    }
}

