/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.webgui.controls;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.renderer.AbstractFormatableColumn;
import com.inet.report.adhoc.server.api.renderer.AdHocRendererFactory;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.webgui.controls.BaseControl;
import com.inet.report.adhoc.webgui.handler.data.ColumnSelectOption;
import com.inet.report.adhoc.webgui.handler.data.DataFilterDescription;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class DataFilterControl
extends BaseControl {
    public DataFilterControl() {
        super("filter", AdHocRendererFactory.FILTER_DEFINITION.getName());
    }

    public static void convertUiModeltoServerModel(@Nonnull Map<String, String> uiModel, @Nonnull Map<RendererPropertyKey<?>, String> serverModel) {
        List<List<DataFilterDescription.DataFilterEntryDescription>> list2;
        DataFilterDescription dataFilterDescription;
        String string = uiModel.get(AdHocRendererFactory.FILTER_DEFINITION.getName());
        if (!StringFunctions.isEmpty((String)string) && (dataFilterDescription = (DataFilterDescription)new Json().fromJson(string, DataFilterDescription.class, Json.NULL_MAP)) != null && (list2 = dataFilterDescription.getFilterLists()) != null) {
            List<List<DataFilter.DataFilterEntry>> list3 = list2.stream().map(list -> list.stream().map(e2 -> {
                String string = e2.getColumn().getValue();
                DataFilter.Operation operation = e2.getOperation();
                LocalizedKey localizedKey = e2.getValue();
                LocalizedKey localizedKey2 = e2.getSecondValue();
                return new DataFilter.DataFilterEntry(string, operation, localizedKey, localizedKey2);
            }).collect(Collectors.toList())).collect(Collectors.toList());
            DataFilter dataFilter = new DataFilter(list3);
            serverModel.put(AdHocRendererFactory.FILTER_DEFINITION, new Json().toJson((Object)dataFilter));
        }
    }

    public static void convertServerModeltoUiModel(@Nonnull Map<RendererPropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        String string = serverModel.get(AdHocRendererFactory.FILTER_DEFINITION);
        if (StringFunctions.isEmpty((String)string)) {
            return;
        }
        DataFilter dataFilter = (DataFilter)new Json().fromJson(string, DataFilter.class, Json.NULL_MAP);
        DataFilterControl.putIntoUiModel(dataFilter, uiModel);
    }

    public static void putIntoUiModel(@Nullable DataFilter filter, @Nonnull Map<String, String> uiModel) {
        if (filter == null) {
            return;
        }
        List<List<DataFilterDescription.DataFilterEntryDescription>> list2 = null;
        List<List<DataFilter.DataFilterEntry>> list3 = filter.getFilterLists();
        if (list3 != null) {
            list2 = list3.stream().map(list -> list.stream().map(e2 -> {
                ColumnSelectOption columnSelectOption = new ColumnSelectOption(e2.getColumnKey(), e2.getColumnKey(), -1, AbstractFormatableColumn.ValueFormat.UNFORMATTED);
                DataFilter.Operation operation = e2.getOperation();
                LocalizedKey localizedKey = e2.getLocalizedValue();
                LocalizedKey localizedKey2 = e2.getLocalizedSecondValue();
                return new DataFilterDescription.DataFilterEntryDescription(columnSelectOption, operation, localizedKey, localizedKey2);
            }).collect(Collectors.toList())).collect(Collectors.toList());
        }
        uiModel.put(AdHocRendererFactory.FILTER_DEFINITION.getName(), new Json().toJson((Object)new DataFilterDescription(list2)));
    }
}

