/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.theming;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.ColorUtils;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.adhoc.AdHocServerPlugin;
import com.inet.report.adhoc.server.api.renderer.AdHocRendererFactory;
import com.inet.report.adhoc.server.api.theming.ThemePropertyKey;
import com.inet.report.adhoc.server.renderer.pageheader.b;
import com.inet.report.adhoc.server.theming.PageHeaderType;
import com.inet.report.adhoc.server.theming.a;
import com.inet.report.adhoc.server.theming.c;
import com.inet.shared.utils.MemoryStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class AdHocTheme {
    @Nonnull
    public static final ThemePropertyKey<String> DEFAULT_FONT_FAMILY = new ThemePropertyKey<String>("font.family", String.class, "DejaVu Sans");
    @Nonnull
    public static final ThemePropertyKey<Integer> DEFAULT_FONT_SIZE = new ThemePropertyKey<Integer>("font.size", Integer.class, 200);
    @Nonnull
    public static final ThemePropertyKey<Integer> DEFAULT_FONT_COLOR = new ThemePropertyKey<Integer>("font.color", Integer.class, 0);
    @Nonnull
    public static final ThemePropertyKey<Integer> BACKGROUND_COLOR = new ThemePropertyKey<Integer>("background.color", Integer.class, 0xFFFFFF);
    @Nonnull
    public static final ThemePropertyKey<Integer> SUMMARY_FONT_COLOR = new ThemePropertyKey<Integer>("summary.font.color", Integer.class, 0);
    @Nonnull
    public static final ThemePropertyKey<Boolean> SUMMARY_FONT_STYLE_BOLD = new ThemePropertyKey<Boolean>("summary.font.style.bold", Boolean.class, true);
    @Nonnull
    public static final ThemePropertyKey<Boolean> SUMMARY_FONT_STYLE_ITALIC = new ThemePropertyKey<Boolean>("summary.font.style.italic", Boolean.class, false);
    @Nonnull
    public static final ThemePropertyKey<Boolean> SUMMARY_FONT_STYLE_UNDERLINE = new ThemePropertyKey<Boolean>("summary.font.style.underline", Boolean.class, false);
    @Nonnull
    public static final ThemePropertyKey<Integer> GROUPS_FONT_SIZE = new ThemePropertyKey<Integer>("groups.font.size", Integer.class, 400);
    @Nonnull
    public static final ThemePropertyKey<Integer> GROUPS_FONT_COLOR = new ThemePropertyKey<Integer>("groups.font.color", Integer.class, 0);
    @Nonnull
    public static final ThemePropertyKey<Boolean> GROUPS_FONT_STYLE_BOLD = new ThemePropertyKey<Boolean>("groups.font.style.bold", Boolean.class, true);
    @Nonnull
    public static final ThemePropertyKey<Boolean> GROUPS_FONT_STYLE_ITALIC = new ThemePropertyKey<Boolean>("groups.font.style.italic", Boolean.class, false);
    @Nonnull
    public static final ThemePropertyKey<Boolean> GROUPS_FONT_STYLE_UNDERLINE = new ThemePropertyKey<Boolean>("groups.font.style.underline", Boolean.class, false);
    @Nullable
    private GUID id;
    @Nonnull
    private String name;
    private Map<ThemePropertyKey<?>, String> properties;

    private AdHocTheme() {
    }

    public AdHocTheme(@Nullable GUID id, @Nonnull String name, @Nonnull Map<ThemePropertyKey<?>, String> properties) {
        this.id = id;
        this.name = name;
        this.properties = Collections.unmodifiableMap(new HashMap(properties));
    }

    @Nullable
    public GUID getID() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    @Nonnull
    public Map<ThemePropertyKey<?>, String> getProperties() {
        if (this.properties == null) {
            this.properties = Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    @Nullable
    public String getValue(@Nonnull ThemePropertyKey<?> key) {
        return this.getProperties().get(key);
    }

    public int getPageBackgroundColor() {
        return this.getIntOrDefault(BACKGROUND_COLOR);
    }

    public PageHeaderType getPageHeaderType() {
        try {
            String string = this.getProperties().get(b.mn);
            if (string != null) {
                return PageHeaderType.valueOf(string);
            }
        }
        catch (Exception exception) {
            AdHocServerPlugin.LOGGER.error((Throwable)exception);
        }
        return b.mn.getDefaultValue();
    }

    public int getIntOrDefault(@Nonnull ThemePropertyKey<Integer> key) {
        try {
            String string = this.getProperties().get(key);
            if (string != null) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            AdHocServerPlugin.LOGGER.error((Throwable)exception);
        }
        return key.getDefaultValue();
    }

    public boolean getBooleanOrDefault(@Nonnull ThemePropertyKey<Boolean> key) {
        try {
            String string = this.getProperties().get(key);
            if (string != null) {
                return Boolean.parseBoolean(string);
            }
        }
        catch (Exception exception) {
            AdHocServerPlugin.LOGGER.error((Throwable)exception);
        }
        return key.getDefaultValue();
    }

    public String[] getStringArrayOrDefault(@Nonnull ThemePropertyKey<String[]> key) {
        try {
            String string = this.getProperties().get(key);
            if (string != null) {
                return (String[])new Json().fromJson(string, String[].class);
            }
        }
        catch (Exception exception) {
            AdHocServerPlugin.LOGGER.error((Throwable)exception);
        }
        return key.getDefaultValue();
    }

    @Nonnull
    public a getPageHeader() {
        return this.getThemeFontFrom(DEFAULT_FONT_FAMILY, DEFAULT_FONT_COLOR, b.mo, b.mp, b.mq, b.mr);
    }

    @Nonnull
    public a getGroups() {
        return this.getThemeFontFrom(DEFAULT_FONT_FAMILY, GROUPS_FONT_COLOR, GROUPS_FONT_SIZE, GROUPS_FONT_STYLE_BOLD, GROUPS_FONT_STYLE_ITALIC, GROUPS_FONT_STYLE_UNDERLINE);
    }

    @Nonnull
    public a getBody() {
        String string = this.getProperties().getOrDefault(DEFAULT_FONT_FAMILY, DEFAULT_FONT_FAMILY.getDefaultValue());
        int n2 = this.getIntOrDefault(DEFAULT_FONT_COLOR);
        int n3 = this.getIntOrDefault(DEFAULT_FONT_SIZE);
        return new a(string, n3, n2, 0);
    }

    @Nonnull
    public a getSummary() {
        return this.getThemeFontFrom(DEFAULT_FONT_FAMILY, SUMMARY_FONT_COLOR, DEFAULT_FONT_SIZE, SUMMARY_FONT_STYLE_BOLD, SUMMARY_FONT_STYLE_ITALIC, SUMMARY_FONT_STYLE_UNDERLINE);
    }

    @Nonnull
    public a getThemeFontFrom(@Nonnull ThemePropertyKey<String> fontFamilyKey, @Nonnull ThemePropertyKey<Integer> colorKey, @Nonnull ThemePropertyKey<Integer> sizeKey, @Nonnull ThemePropertyKey<Boolean> boldStyleKey, @Nonnull ThemePropertyKey<Boolean> italicStyleKey, @Nonnull ThemePropertyKey<Boolean> underlineStyleKey) {
        String string = this.getProperties().getOrDefault(fontFamilyKey, fontFamilyKey.getDefaultValue());
        int n2 = this.getIntOrDefault(colorKey);
        int n3 = this.getIntOrDefault(sizeKey);
        boolean bl = this.getBooleanOrDefault(boldStyleKey);
        boolean bl2 = this.getBooleanOrDefault(italicStyleKey);
        boolean bl3 = this.getBooleanOrDefault(underlineStyleKey);
        int n4 = AdHocTheme.calcFontStyle(bl, bl2, bl3);
        return new a(string, n3, n2, n4);
    }

    private static int calcFontStyle(boolean bold, boolean italic, boolean underline) {
        int n2 = 0;
        if (bold) {
            ++n2;
        }
        if (italic) {
            n2 += 2;
        }
        if (underline) {
            n2 += 4;
        }
        return n2;
    }

    public byte @Nonnull [] toCSS() {
        return this.toCSS(null);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public byte @Nonnull [] toCSS(@Nullable Set<@Nonnull String> extensionsToInclude) {
        int n2;
        int n3;
        MemoryStream memoryStream = new MemoryStream();
        memoryStream.writeASCII(".adhocthemedcontainer.printtablelayout {");
        AdHocTheme.appendFontFromTheme(memoryStream, this.getBody());
        memoryStream.write(125);
        memoryStream.writeASCII(".adhocthemedcontainer, .adhocthemedcontainer .stickyheader {background-color: ");
        ColorUtils.appendHtmlColor((MemoryStream)memoryStream, (int)this.getPageBackgroundColor());
        memoryStream.write(125);
        int n4 = this.getIntOrDefault(DEFAULT_FONT_SIZE);
        a a2 = this.getGroups();
        int n5 = a2.bk();
        c c2 = new c(n5, n4);
        memoryStream.write(10);
        memoryStream.writeASCII(".adhocthemedcontainer {\n");
        memoryStream.writeASCII("--adhoc-header-line-height: 1.2;\n");
        for (n3 = 1; n3 <= 6; ++n3) {
            n2 = c2.v(n3);
            memoryStream.writeASCII("--adhoc-header-" + n3 + "-size: " + String.valueOf((double)n2 / 20.0) + "pt;\n");
        }
        memoryStream.write(125);
        memoryStream.writeASCII("div > h1.adhocthemed, div > h2.adhocthemed, div > h3.adhocthemed, div > h4.adhocthemed, div > h5.adhocthemed, div > h6.adhocthemed {");
        memoryStream.writeASCII("margin:0; margin-top:10px; margin-bottom:10px;");
        memoryStream.writeASCII("line-height:1.2;");
        AdHocTheme.appendFontFromTheme(memoryStream, a2);
        memoryStream.write(125);
        memoryStream.writeASCII("div > h1.adhocthemed {margin-top: 20px;}");
        memoryStream.writeASCII("div:first-child > h1.adhocthemed {margin-top: 0;}");
        for (n3 = 2; n3 <= 6; ++n3) {
            n2 = c2.v(n3);
            if (n2 == n5) continue;
            memoryStream.write(104);
            memoryStream.writeASCII(String.valueOf(n3));
            memoryStream.writeASCII(".adhocthemed{font-size:");
            memoryStream.writeASCII(String.valueOf((double)n2 / 20.0));
            memoryStream.writeASCII("pt}");
        }
        @Nonnull List list = ServerPluginManager.getInstance().get(AdHocRendererFactory.class);
        for (AdHocRendererFactory adHocRendererFactory : list) {
            if (extensionsToInclude != null && !extensionsToInclude.contains(adHocRendererFactory.getExtensionName())) continue;
            adHocRendererFactory.appendCSS(this, memoryStream);
        }
        return memoryStream.toByteArray();
    }

    public static void appendFontFromTheme(MemoryStream stream, a themeFont) {
        stream.writeASCII("font-family:\"");
        stream.writeUTF8(themeFont.getName());
        stream.writeASCII("\";color:");
        ColorUtils.appendHtmlColor((MemoryStream)stream, (int)themeFont.bE());
        stream.writeASCII(";font-size:");
        stream.writeASCII(String.valueOf((double)themeFont.bk() / 20.0));
        stream.writeASCII("pt");
        stream.writeASCII(";font-weight:");
        stream.writeASCII((themeFont.bF() & 1) == 1 ? "bold" : "normal");
        stream.writeASCII(";font-style:");
        stream.writeASCII((themeFont.bF() & 2) == 2 ? "italic" : "normal");
        if ((themeFont.bF() & 4) == 4) {
            stream.writeASCII(";text-decoration:underline");
        }
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.properties);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdHocTheme adHocTheme = (AdHocTheme)obj;
        return Objects.equals(this.id, adHocTheme.id) && Objects.equals(this.name, adHocTheme.name) && Objects.equals(this.properties, adHocTheme.properties);
    }
}

