/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.designer;

import com.inet.annotations.JsonData;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class RenderedElement {
    @Nullable
    private String parentRendererID;
    @Nonnull
    private String rendererID;
    @Nonnull
    private String html;

    @Nonnull
    public static String createRendererID(int page) {
        return String.format("page_%d", page);
    }

    @Nonnull
    public static String createRendererID(@Nonnull String designerID, int recordIndex, int page) {
        return String.format("%s_%d_%d", designerID, recordIndex, page);
    }

    @Nonnull
    public static String createRendererID(@Nonnull String parentOfSubReportRendererID, @Nonnull String designerID, int recordIndex, int page) {
        return RenderedElement.createRendererID(designerID, recordIndex, page) + parentOfSubReportRendererID.substring(parentOfSubReportRendererID.indexOf(95));
    }

    @Nonnull
    public static RenderedElement forPage(int pageIndex) {
        String string = RenderedElement.createRendererID(pageIndex);
        String string2 = String.format("<div id='%s' class='%s'></div>", string, string);
        return new RenderedElement(null, string, string2);
    }

    @Nonnull
    public static RenderedElement forElement(@Nonnull String parentRendererID, @Nonnull String rendererID, @Nonnull String html) {
        return new RenderedElement(parentRendererID, rendererID, html);
    }

    private RenderedElement() {
    }

    private RenderedElement(@Nullable String parentRendererID, @Nonnull String rendererID, @Nonnull String html) {
        this.parentRendererID = parentRendererID;
        this.rendererID = rendererID;
        this.html = html;
    }

    @Nullable
    public String getParentRendererID() {
        return this.parentRendererID;
    }

    @Nonnull
    public String getRendererID() {
        return this.rendererID;
    }

    @Nonnull
    public String getHTML() {
        return this.html;
    }

    public int hashCode() {
        return Objects.hash(this.html, this.parentRendererID, this.rendererID);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenderedElement renderedElement = (RenderedElement)obj;
        return Objects.equals(this.html, renderedElement.html) && Objects.equals(this.parentRendererID, renderedElement.parentRendererID) && Objects.equals(this.rendererID, renderedElement.rendererID);
    }
}

