/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.renderer;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.ColorUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.adhoc.server.api.common.ValidationException;
import com.inet.report.adhoc.server.api.common.a;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataViewDefinition;
import com.inet.report.adhoc.server.api.renderer.AdHocDefinition;
import com.inet.report.adhoc.server.api.renderer.PreviewData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.b;
import com.inet.report.adhoc.server.api.theming.ThemePropertyKey;
import com.inet.report.adhoc.server.theming.AdHocTheme;
import com.inet.report.adhoc.webgui.controls.ComponentSettings;
import com.inet.report.adhoc.webgui.controls.DataFilterControl;
import com.inet.report.adhoc.webgui.controls.DataSelectControl;
import com.inet.report.adhoc.webgui.handler.data.ColumnSelectOption;
import com.inet.shared.utils.MemoryStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class AdHocRendererFactory<RENDERER extends b>
extends a<RENDERER, AdHocDefinition> {
    protected static final String[] DEFAULT_STRINGS = new String[0];
    @Nonnull
    public static final RendererPropertyKey<DataViewDefinition> DATA_DEFINITION = new RendererPropertyKey<DataViewDefinition>("source", DataViewDefinition.class);
    @Nonnull
    public static final RendererPropertyKey<DataFilter> FILTER_DEFINITION = new RendererPropertyKey<DataFilter>("filter", DataFilter.class);

    public AdHocRendererFactory(@Nonnull String extensionName) {
        super(extensionName);
    }

    @Override
    public void validate(@Nonnull AdHocDefinition definition) throws ValidationException {
        String string = definition.getProperties().get(DATA_DEFINITION);
        if (StringFunctions.isEmpty((String)string)) {
            throw new ValidationException("source", com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.noDataSource", new Object[0]));
        }
        DataViewDefinition dataViewDefinition = (DataViewDefinition)new Json().fromJson(string, DataViewDefinition.class, Json.NULL_MAP);
        if (dataViewDefinition == null) {
            throw new ValidationException("source", com.inet.report.adhoc.server.renderer.a.bm.getMsg("err.noDataSource", new Object[0]));
        }
        com.inet.report.adhoc.server.api.dataview.b.L().a(dataViewDefinition);
    }

    @Nonnull
    public abstract b createInstanceFrom(@Nonnull AdHocDefinition var1);

    @Nonnull
    public abstract ComponentSettings getComponentSettings(@Nonnull com.inet.report.adhoc.webgui.controls.a var1);

    @Nonnull
    public abstract ComponentSettings getDefaultSettings();

    @Nullable
    public abstract ComponentSettings getThemeSettings();

    public abstract void appendCSS(@Nonnull AdHocTheme var1, @Nonnull MemoryStream var2);

    public void convertUiModeltoServerModel(@Nonnull Map<String, String> uiModel, @Nonnull Map<RendererPropertyKey<?>, String> serverModel) {
        DataSelectControl.convertUiModeltoServerModel(uiModel, serverModel);
        DataFilterControl.convertUiModeltoServerModel(uiModel, serverModel);
    }

    protected void transferUiProperty(@Nonnull RendererPropertyKey<?> key, @Nonnull Map<String, String> uiModel, @Nonnull Map<RendererPropertyKey<?>, String> serverModel) {
        String string = uiModel.get(key.getName());
        if (!StringFunctions.isEmpty((String)string)) {
            serverModel.put(key, string);
        }
    }

    protected void convertUiPropertyThatIsNotListBased(@Nonnull String uiKey, @Nonnull RendererPropertyKey<?> serverKey, @Nonnull Function<ColumnSelectOption, Object> converter, @Nonnull Map<String, String> uiModel, @Nonnull Map<RendererPropertyKey<?>, String> serverModel) {
        Json json;
        Map map;
        List list;
        String string = uiModel.get(uiKey);
        if (string != null && (list = (List)(map = Objects.requireNonNull((Map)(json = new Json()).fromJson(string, (Type)new JsonParameterizedType(Map.class, new Type[]{String.class, new JsonParameterizedType(List.class, new Type[]{ColumnSelectOption.class})})))).get(serverKey.getName())) != null && !list.isEmpty()) {
            ColumnSelectOption columnSelectOption = (ColumnSelectOption)((Object)list.get(0));
            Objects.requireNonNull(columnSelectOption.getValue());
            Object object = Objects.requireNonNull(converter.apply(columnSelectOption));
            serverModel.put(serverKey, json.toJson(object));
        }
    }

    protected void convertUiProperty(@Nonnull String uiKey, @Nonnull RendererPropertyKey<?> serverKey, @Nonnull Function<ColumnSelectOption, Object> converter, @Nonnull Map<String, String> uiModel, @Nonnull Map<RendererPropertyKey<?>, String> serverModel) {
        String string = uiModel.get(uiKey);
        if (string != null) {
            Json json = new Json();
            Map map = Objects.requireNonNull((Map)json.fromJson(string, (Type)new JsonParameterizedType(Map.class, new Type[]{String.class, new JsonParameterizedType(List.class, new Type[]{ColumnSelectOption.class})})));
            List list = (List)map.get(serverKey.getName());
            if (list != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (ColumnSelectOption columnSelectOption : list) {
                    Objects.requireNonNull(columnSelectOption.getValue());
                    arrayList.add(Objects.requireNonNull(converter.apply(columnSelectOption)));
                }
                if (!arrayList.isEmpty()) {
                    serverModel.put(serverKey, json.toJson(arrayList));
                }
            }
        }
    }

    public void convertServerModeltoUiModel(@Nonnull Map<RendererPropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        DataSelectControl.convertServerModeltoUiModel(serverModel, uiModel);
        DataFilterControl.convertServerModeltoUiModel(serverModel, uiModel);
    }

    protected void transferServerProperty(@Nonnull RendererPropertyKey<?> key, @Nonnull Map<RendererPropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        String string = serverModel.get(key);
        if (!StringFunctions.isEmpty((String)string)) {
            uiModel.put(key.getName(), string);
        }
    }

    protected void transferServerPropertyOrDefault(@Nonnull RendererPropertyKey<?> key, @Nonnull Map<RendererPropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel, @Nonnull String defaultValue) {
        String string = serverModel.get(key);
        if (StringFunctions.isEmpty((String)string)) {
            string = defaultValue;
        }
        uiModel.put(key.getName(), string);
    }

    protected void convertServerProperty(@Nonnull RendererPropertyKey<?> serverKey, @Nonnull String uiKey, @Nonnull BiConsumer<String, List<ColumnSelectOption>> converter, @Nonnull Map<RendererPropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        String string = serverModel.get(serverKey);
        if (string != null) {
            Json json = new Json();
            String string2 = uiModel.get(uiKey);
            @Nonnull HashMap<String, ArrayList<E>> hashMap = string2 == null ? new HashMap() : (Map)json.fromJson(string2, (Type)new JsonParameterizedType(Map.class, new Type[]{String.class, new JsonParameterizedType(List.class, new Type[]{ColumnSelectOption.class})}));
            ArrayList arrayList = new ArrayList();
            converter.accept(string, arrayList);
            hashMap.put(serverKey.getName(), arrayList);
            uiModel.put(uiKey, json.toJson(hashMap));
        }
    }

    @Nonnull
    public abstract URL getIconURL();

    protected abstract void convertThemeSettingsFromUiModelToServerModel(@Nonnull Map<String, String> var1, @Nonnull Map<ThemePropertyKey<?>, String> var2);

    protected abstract void convertThemeSettingsFromServerModelToUiModel(@Nonnull Map<ThemePropertyKey<?>, String> var1, @Nonnull Map<String, String> var2);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nonnull
    public static Map<ThemePropertyKey<?>, String> convertThemeSettingsFromUiModelToServerModel(@Nonnull Map<String, String> uiModel) {
        HashMap hashMap = new HashMap();
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToServerModel(AdHocTheme.DEFAULT_FONT_FAMILY, uiModel, hashMap);
        AdHocRendererFactory.transferConvertedPointsToTwipsOrDefaultToServerModel(AdHocTheme.DEFAULT_FONT_SIZE, uiModel, hashMap);
        AdHocRendererFactory.transferConvertedHtmlColorToAbgrOrDefaultToServerModel(AdHocTheme.DEFAULT_FONT_COLOR, uiModel, hashMap);
        AdHocRendererFactory.transferConvertedHtmlColorToAbgrOrDefaultToServerModel(AdHocTheme.BACKGROUND_COLOR, uiModel, hashMap);
        AdHocRendererFactory.transferConvertedHtmlColorToAbgrOrDefaultToServerModel(AdHocTheme.SUMMARY_FONT_COLOR, uiModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToServerModel(AdHocTheme.SUMMARY_FONT_STYLE_BOLD, uiModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToServerModel(AdHocTheme.SUMMARY_FONT_STYLE_ITALIC, uiModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToServerModel(AdHocTheme.SUMMARY_FONT_STYLE_UNDERLINE, uiModel, hashMap);
        AdHocRendererFactory.transferConvertedPointsToTwipsOrDefaultToServerModel(AdHocTheme.GROUPS_FONT_SIZE, uiModel, hashMap);
        AdHocRendererFactory.transferConvertedHtmlColorToAbgrOrDefaultToServerModel(AdHocTheme.GROUPS_FONT_COLOR, uiModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToServerModel(AdHocTheme.GROUPS_FONT_STYLE_BOLD, uiModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToServerModel(AdHocTheme.GROUPS_FONT_STYLE_ITALIC, uiModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToServerModel(AdHocTheme.GROUPS_FONT_STYLE_UNDERLINE, uiModel, hashMap);
        @Nonnull List list = ServerPluginManager.getInstance().get(AdHocRendererFactory.class);
        for (AdHocRendererFactory adHocRendererFactory : list) {
            adHocRendererFactory.convertThemeSettingsFromUiModelToServerModel(uiModel, hashMap);
        }
        return hashMap;
    }

    protected static void transferUnconvertedValueOrDefaultToServerModel(@Nonnull ThemePropertyKey<?> key, @Nonnull Map<String, String> uiModel, @Nonnull Map<ThemePropertyKey<?>, String> serverModel) {
        String string = uiModel.getOrDefault(key.getName(), String.valueOf(key.getDefaultValue()));
        serverModel.put(key, string);
    }

    protected static <T> void transferArrayOrDefaultToServerModel(@Nonnull ThemePropertyKey<T[]> key, @Nonnull Map<String, String> uiModel, @Nonnull Map<ThemePropertyKey<?>, String> serverModel) {
        String string = uiModel.get(key.getName());
        if (string == null) {
            string = new Json().toJson(key.getDefaultValue());
        }
        serverModel.put(key, string);
    }

    protected static void transferConvertedPointsToTwipsOrDefaultToServerModel(@Nonnull ThemePropertyKey<Integer> key, @Nonnull Map<String, String> uiModel, @Nonnull Map<ThemePropertyKey<?>, String> serverModel) {
        int n2;
        String string = uiModel.get(key.getName());
        try {
            n2 = Integer.parseInt(string) * 20;
        }
        catch (Exception exception) {
            n2 = key.getDefaultValue();
        }
        serverModel.put(key, String.valueOf(n2));
    }

    protected static void transferConvertedHtmlColorToAbgrOrDefaultToServerModel(@Nonnull ThemePropertyKey<Integer> key, @Nonnull Map<String, String> uiModel, @Nonnull Map<ThemePropertyKey<?>, String> serverModel) {
        int n2;
        String string = uiModel.get(key.getName());
        try {
            n2 = ColorUtils.convertHtmlColorToAbgr((String)string);
        }
        catch (Exception exception) {
            n2 = key.getDefaultValue();
        }
        serverModel.put(key, String.valueOf(n2));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nonnull
    public static Map<String, String> convertThemeSettingsFromServerModelToUiModel(@Nonnull Map<ThemePropertyKey<?>, String> serverModel) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToUiModel(AdHocTheme.DEFAULT_FONT_FAMILY, serverModel, hashMap);
        AdHocRendererFactory.transferConvertedTwipsToPointsOrDefaultToUiModel(AdHocTheme.DEFAULT_FONT_SIZE, serverModel, hashMap);
        AdHocRendererFactory.transferConvertedAbgrToHtmlColorOrDefaultToUiModel(AdHocTheme.DEFAULT_FONT_COLOR, serverModel, hashMap);
        AdHocRendererFactory.transferConvertedAbgrToHtmlColorOrDefaultToUiModel(AdHocTheme.BACKGROUND_COLOR, serverModel, hashMap);
        AdHocRendererFactory.transferConvertedAbgrToHtmlColorOrDefaultToUiModel(AdHocTheme.SUMMARY_FONT_COLOR, serverModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToUiModel(AdHocTheme.SUMMARY_FONT_STYLE_BOLD, serverModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToUiModel(AdHocTheme.SUMMARY_FONT_STYLE_ITALIC, serverModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToUiModel(AdHocTheme.SUMMARY_FONT_STYLE_UNDERLINE, serverModel, hashMap);
        AdHocRendererFactory.transferConvertedTwipsToPointsOrDefaultToUiModel(AdHocTheme.GROUPS_FONT_SIZE, serverModel, hashMap);
        AdHocRendererFactory.transferConvertedAbgrToHtmlColorOrDefaultToUiModel(AdHocTheme.GROUPS_FONT_COLOR, serverModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToUiModel(AdHocTheme.GROUPS_FONT_STYLE_BOLD, serverModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToUiModel(AdHocTheme.GROUPS_FONT_STYLE_ITALIC, serverModel, hashMap);
        AdHocRendererFactory.transferUnconvertedValueOrDefaultToUiModel(AdHocTheme.GROUPS_FONT_STYLE_UNDERLINE, serverModel, hashMap);
        @Nonnull List list = ServerPluginManager.getInstance().get(AdHocRendererFactory.class);
        for (AdHocRendererFactory adHocRendererFactory : list) {
            adHocRendererFactory.convertThemeSettingsFromServerModelToUiModel(serverModel, hashMap);
        }
        return hashMap;
    }

    protected static void transferUnconvertedValueOrDefaultToUiModel(@Nonnull ThemePropertyKey<?> key, @Nonnull Map<ThemePropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        String string = serverModel.getOrDefault(key, String.valueOf(key.getDefaultValue()));
        uiModel.put(key.getName(), string);
    }

    protected static <T> void transferArrayOrDefaultToUiModel(@Nonnull ThemePropertyKey<T[]> key, @Nonnull Map<ThemePropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        String string = serverModel.get(key);
        if (string == null) {
            string = new Json().toJson(key.getDefaultValue());
        }
        uiModel.put(key.getName(), string);
    }

    protected static void transferConvertedTwipsToPointsOrDefaultToUiModel(@Nonnull ThemePropertyKey<Integer> key, @Nonnull Map<ThemePropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        int n2;
        String string = serverModel.get(key);
        try {
            n2 = Integer.parseInt(string) / 20;
        }
        catch (Exception exception) {
            n2 = key.getDefaultValue() / 20;
        }
        uiModel.put(key.getName(), String.valueOf(n2));
    }

    protected static void transferConvertedAbgrToHtmlColorOrDefaultToUiModel(@Nonnull ThemePropertyKey<Integer> key, @Nonnull Map<ThemePropertyKey<?>, String> serverModel, @Nonnull Map<String, String> uiModel) {
        String string;
        String string2 = serverModel.get(key);
        try {
            string = ColorUtils.convertAbgrToHtmlColor((int)Integer.parseInt(string2));
        }
        catch (Exception exception) {
            string = ColorUtils.convertAbgrToHtmlColor((int)key.getDefaultValue());
        }
        uiModel.put(key.getName(), string);
    }

    @Nullable
    public abstract PreviewData getPreviewData(@Nullable GUID var1);
}

