/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.dataview;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.plugin.NamedExtension;
import com.inet.remote.gui.angular.usersorgroupsselection.UsersOrGroupsSelection;
import com.inet.report.Engine;
import com.inet.report.FieldElement;
import com.inet.report.ReportException;
import com.inet.report.adhoc.AdHocServerPlugin;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.DataViewAccessList;
import com.inet.report.adhoc.server.api.dataview.DataViewDefinition;
import com.inet.report.adhoc.server.api.dataview.DataViewPropertyKey;
import com.inet.report.adhoc.server.api.dataview.PersistenceTemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.AdHocRendererFactory;
import com.inet.report.adhoc.server.api.renderer.DataField;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.adhoc.server.api.renderer.table.TableSortingData;
import com.inet.report.adhoc.server.dataview.datasource.a;
import com.inet.report.adhoc.server.renderer.chart.d;
import com.inet.report.adhoc.server.renderer.crosstab.c;
import com.inet.report.adhoc.server.renderer.table.b;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface TemplateDataViewDefaults
extends NamedExtension {
    @Nonnull
    public static final RendererPropertyKey<DataViewDefinition> TEMPLATESOURCE_KEY = new RendererPropertyKey<DataViewDefinition>("templatesource", DataViewDefinition.class);
    @Nonnull
    public static final DataViewPropertyKey<String> TEMPLATESOURCE_DATASOURCE = a.cm;
    @Nonnull
    public static final DataViewPropertyKey<List<LocalizedKey>> TEMPLATESOURCE_TABLES_KEY = new DataViewPropertyKey<List>(String.valueOf(TEMPLATESOURCE_KEY) + ".tables", List.class);
    @Nonnull
    public static final DataViewPropertyKey<List<PersistenceTemplateDataViewDefaults.Join>> TEMPLATESOURCE_JOINS_KEY = new DataViewPropertyKey<List>(String.valueOf(TEMPLATESOURCE_KEY) + ".joins", List.class);
    @Nonnull
    public static final DataViewPropertyKey<List<LocalizedKey>> TEMPLATESOURCE_COLUMNS_KEY = new DataViewPropertyKey<List>(String.valueOf(TEMPLATESOURCE_KEY) + ".columns", List.class);
    @Nonnull
    public static final RendererPropertyKey<List<UsersOrGroupsSelection.SelectedMember>> ACCESS_LIST_KEY = new RendererPropertyKey<List>("accesslist", List.class);
    public static final RendererPropertyKey<DataFilter> FILTER_DEFINITION = AdHocRendererFactory.FILTER_DEFINITION;
    @Nonnull
    public static final RendererPropertyKey<TableColumnData[]> TABLE_COLUMNS = b.TABLE_COLUMNS;
    @Nonnull
    public static final RendererPropertyKey<GroupData[]> TABLE_GROUPS = b.TABLE_GROUPS;
    @Nonnull
    public static final RendererPropertyKey<TableSortingData[]> TABLE_SORTING = b.TABLE_SORTING;
    @Nonnull
    public static final RendererPropertyKey<GroupData[]> CROSSTAB_COLUMNS = c.CROSSTAB_COLUMNS;
    @Nonnull
    public static final RendererPropertyKey<GroupData[]> CROSSTAB_ROWS = c.CROSSTAB_ROWS;
    @Nonnull
    public static final RendererPropertyKey<DataField[]> CROSSTAB_DATA = c.CROSSTAB_DATA;
    @Nonnull
    public static final RendererPropertyKey<GroupData[]> CROSSTAB_GROUPS = c.CROSSTAB_GROUPS;
    @Nonnull
    public static final RendererPropertyKey<GroupData> CHART_CATEGORY = d.CHART_CATEGORY;
    @Nonnull
    public static final RendererPropertyKey<DataField[]> CHART_DATA_FIELDS = d.CHART_DATA_FIELDS;

    @Nonnull
    public GUID getID();

    @Nonnull
    default public String getDisplayName() {
        return this.getExtensionName();
    }

    @Nullable
    default public String getDescription() {
        return null;
    }

    @Nullable
    default public <T> T get(@Nonnull RendererPropertyKey<T> key) {
        try {
            String string = this.getString(key);
            if (string == null) {
                return null;
            }
            if (key.getType() == String.class) {
                return (T)string;
            }
            return (T)new Json().fromJson(string, key.getType());
        }
        catch (Throwable throwable) {
            AdHocServerPlugin.LOGGER.warn((Object)throwable);
            return null;
        }
    }

    @Nullable
    default public <T> String getString(@Nonnull RendererPropertyKey<T> key) {
        T t2 = this.get(key);
        return t2 != null ? new Json().toJson(t2) : null;
    }

    @Nonnull
    public DataViewAccessList getAccessList();

    default public boolean hasAccess(@Nonnull GUID accountID) {
        DataViewAccessList dataViewAccessList = this.getAccessList();
        if (dataViewAccessList.getUserIDs().contains(accountID)) {
            return true;
        }
        Set<@Nonnull GUID> set = dataViewAccessList.getGroupIDs();
        if (set.isEmpty()) {
            return false;
        }
        if (set.contains(UsersAndGroups.GROUPID_ALLUSERS)) {
            return true;
        }
        UserGroupManager userGroupManager = UserGroupManager.getRecoveryEnabledInstance();
        for (UserGroupInfo userGroupInfo : userGroupManager.getGroupsForUser(accountID)) {
            if (!set.contains(userGroupInfo.getID())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public @Nonnull List<@Nonnull Column> getAvailableColumns();

    @Nonnull
    public DataView createDataView(@Nonnull Engine var1, @Nullable DataFilter var2);

    default public void setSelectionFormula(@Nonnull Engine engine, @Nullable DataFilter filter) throws ReportException {
        com.inet.report.adhoc.server.dataview.datasource.b.setSelectionFormula(engine, filter);
    }

    @Nullable
    default public List<LocalizedKey> getFilterSuggestions(@Nonnull Engine engine, @Nonnull String filterColumn, @Nonnull String filterText) {
        return null;
    }

    default public void applySpecialFormat(@Nonnull FieldElement el) throws ReportException {
    }

    @Nullable
    default public String getSortField(@Nonnull String name) {
        return null;
    }

    @JsonData
    @PublicApi
    public static class Column
    extends LocalizedKey {
        private int dataType;

        private Column() {
        }

        public Column(@Nonnull String name, @Nullable String label, int dataType) {
            super(Objects.requireNonNull(name), Objects.equals(name, label) ? null : label);
            this.dataType = dataType;
        }

        public int getDataType() {
            return this.dataType;
        }

        @Nonnull
        public String getDisplayName() {
            String string = super.getDisplayName();
            if (string == null) {
                string = this.getKey();
            }
            return string;
        }
    }
}

