/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.datasource;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Datasource;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.AdHocServerPlugin;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.datasource.DataViewConditions;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.SimpleResultSet;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.takeout.TakeoutDataRenderer;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class UserDataSourceConfiguration
extends BaseDataFactory {
    public static final String DATASOURCE_USERS = "Users";
    public static final String PROMPT_USER_SEARCH_CONDITIONS = "UserSearchPhrase";
    public static final String TABLE_NAME_USER_ADHOC = "UserAdhoc";
    public static final String TABLE_NAME_USER_GROUPS = "UserGroups";
    public static final String TABLE_NAME_USER_GROUP_MEMBERSHIPS = "UserGroupMemberships";
    public static final String COLUMN_USER_NAME = "username";
    public static final String COLUMN_USER_GUID = "userGUID";
    public static final String COLUMN_USER_ACTIVE = "userActive";
    public static final String COLUMN_USER_LOCKED = "userLocked";
    public static final String COLUMN_USERGROUP_ID = "usergroupid";
    public static final String COLUMN_USERGROUP_NAME = "usergroupname";
    public static final String COLUMN_USERGROUP_TYPE = "grouptype";

    public boolean getReportDataPerInstance() {
        return true;
    }

    @Nonnull
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        String string;
        Object object;
        Set set;
        Object object2;
        Object object3;
        List list = ts.getInputParameters();
        switch (ts.getDatabaseIdentifier()) {
            case "User": {
                if (!list.isEmpty()) {
                    object3 = (PromptField)list.get(0);
                    object2 = (GUID)object3.getValue();
                    set = Collections.singleton(object2);
                    break;
                }
            }
            case "UserAdhoc": {
                String string2;
                object3 = ts.getInputParameters().stream().filter(promptField -> promptField.getName().equals(PROMPT_USER_SEARCH_CONDITIONS)).findFirst();
                object2 = UserManager.getInstance();
                if (object3.isPresent() && !StringFunctions.isEmpty((String)(string2 = (String)(object = ((PromptField)object3.get()).getValue())))) {
                    AndSearchExpression andSearchExpression = UserDataSourceConfiguration.buildSearchExpressionFromFilter((DataViewConditions)new Json().fromJson(string2, DataViewConditions.class));
                    SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{andSearchExpression});
                    searchCommand.setResultLimit(10000);
                    set = object2.searchAsUser(searchCommand).getEntries().stream().map(searchResultEntry -> (GUID)searchResultEntry.getId()).collect(Collectors.toSet());
                    break;
                }
                object = new SearchCommand(new SearchExpression[0]);
                object.setResultLimit(10000);
                set = object2.searchAsUser((SearchCommand)object).getEntries().stream().map(searchResultEntry -> (GUID)searchResultEntry.getId()).collect(Collectors.toSet());
                break;
            }
            case "UserGroupMemberships": {
                if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN)) {
                    set = Set.of();
                    break;
                }
            }
            case "UserGroups": {
                SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{new SearchCondition("groupname", SearchCondition.SearchTermOperator.StartsWith, (Object)"")});
                set = UserGroupManager.getInstance().getSearchEngine().simpleSearch(searchCommand);
                set.remove(UsersAndGroups.GROUPID_ALLUSERS);
                break;
            }
            default: {
                throw new UnsupportedOperationException(ts.getDatabaseIdentifier());
            }
        }
        if (ts.getDatabaseIdentifier().equals("User")) {
            string = UserManager.getInstance();
            List<String> list2 = this.getColumns(ts).stream().filter(columnInfo -> columnInfo.getColumnType() == 3).map(columnInfo -> columnInfo.getName()).collect(Collectors.toList());
            object3 = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
            object2 = object3.stream().filter(fieldDefinition -> fieldDefinition instanceof UserFieldDefinition && "user.masterdata".equals(fieldDefinition.getGroupKey()) && fieldDefinition.getFieldKey() != null).sorted((fieldDefinition, fieldDefinition2) -> Integer.compare(fieldDefinition.getPriority(), fieldDefinition2.getPriority())).collect(Collectors.toList());
            object = new SimpleResultSet(list2.toArray(new String[list2.size()]), (UserManager)string, ts, (List)object2){
                private final Iterator<GUID> bP;
                final /* synthetic */ UserManager bR;
                final /* synthetic */ TableSource bS;
                final /* synthetic */ List bT;
                {
                    this.bR = userManager;
                    this.bS = tableSource;
                    this.bT = list;
                    super(stringArray);
                    this.bP = set.iterator();
                }

                public boolean next() throws SQLException {
                    if (this.getRowCount() > 0) {
                        return super.next();
                    }
                    while (this.bP.hasNext()) {
                        GUID gUID = this.bP.next();
                        UserAccount userAccount = this.bR.getUserAccount(gUID);
                        if (userAccount == null || !this.bS.getDatabaseIdentifier().equals("User")) continue;
                        for (UserFieldDefinition userFieldDefinition : this.bT) {
                            if (!userFieldDefinition.isAvailable(userAccount)) continue;
                            FieldValue fieldValue = userFieldDefinition.getFieldValue(userAccount);
                            String string = UserDataSourceConfiguration.a(userFieldDefinition.getDisplayType(), fieldValue);
                            Object[] objectArray = new Object[5];
                            objectArray[0] = gUID.toString();
                            objectArray[1] = userFieldDefinition.getLabel();
                            objectArray[2] = userFieldDefinition.getFieldKey();
                            objectArray[3] = string;
                            if (string == null || string.isEmpty()) continue;
                            this.getAllRows().add(objectArray);
                        }
                    }
                    return super.next();
                }
            };
            return new TableData((ResultSet)object);
        }
        if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_ADHOC)) {
            string = UserManager.getInstance();
            List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> list3 = this.l(ts.getDatabaseIdentifier());
            object3 = new SimpleResultSet(list3.stream().map(entry -> ((DataSourceUtils.ColumnInfoWithLabel)((Object)((Object)entry.getValue()))).getName()).collect(Collectors.toList()).toArray(new String[list3.size()]), (UserManager)string, list3){
                private final Iterator<GUID> bP;
                final /* synthetic */ UserManager bR;
                final /* synthetic */ List bV;
                {
                    this.bR = userManager;
                    this.bV = list;
                    super(stringArray);
                    this.bP = set.iterator();
                }

                public boolean next() throws SQLException {
                    while (this.bP.hasNext()) {
                        GUID gUID = this.bP.next();
                        UserAccount userAccount = this.bR.getUserAccount(gUID);
                        if (userAccount == null) continue;
                        Object[] objectArray = new Object[this.bV.size()];
                        for (int i2 = 0; i2 < this.bV.size(); ++i2) {
                            Map.Entry entry = (Map.Entry)this.bV.get(i2);
                            if (((String)entry.getKey()).equals(UserDataSourceConfiguration.COLUMN_USER_GUID)) {
                                objectArray[i2] = userAccount.getID().toString();
                                continue;
                            }
                            if (((String)entry.getKey()).equals(UserDataSourceConfiguration.COLUMN_USER_NAME)) {
                                objectArray[i2] = userAccount.getDisplayName();
                                continue;
                            }
                            if (((String)entry.getKey()).equals(UserDataSourceConfiguration.COLUMN_USER_ACTIVE)) {
                                objectArray[i2] = userAccount.isActive();
                                continue;
                            }
                            if (((String)entry.getKey()).equals(UserDataSourceConfiguration.COLUMN_USER_LOCKED)) {
                                objectArray[i2] = userAccount.getValue(this.bR.getField("blockingnotice")) != null;
                                continue;
                            }
                            if (((DataSourceUtils.ColumnInfoWithLabel)((Object)entry.getValue())).getColumnType() != 3) continue;
                            UserField userField = UsersAndGroups.getFieldByKey((String)((String)entry.getKey()));
                            objectArray[i2] = DataSourceUtils.showDisplayValueForField(userField) ? userField.getFieldType().getDisplayValue(userAccount.getValue(userField)) : DataSourceUtils.convertFieldValueToReportingValue(userAccount.getValue(userField), userField);
                        }
                        this.getAllRows().add(objectArray);
                        return super.next();
                    }
                    return false;
                }
            };
            return new TableData((ResultSet)object3);
        }
        if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_GROUPS)) {
            string = UserGroupManager.getInstance();
            List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> list4 = this.l(ts.getDatabaseIdentifier());
            object3 = new SimpleResultSet(list4.stream().map(entry -> ((DataSourceUtils.ColumnInfoWithLabel)((Object)((Object)entry.getValue()))).getName()).collect(Collectors.toList()).toArray(new String[list4.size()]), (UserGroupManager)string, list4){
                private final Iterator<GUID> bP;
                final /* synthetic */ UserGroupManager bW;
                final /* synthetic */ List bV;
                {
                    this.bW = userGroupManager;
                    this.bV = list;
                    super(stringArray);
                    this.bP = set.iterator();
                }

                public boolean next() throws SQLException {
                    while (this.bP.hasNext()) {
                        GUID gUID = this.bP.next();
                        UserGroupInfo userGroupInfo = this.bW.getGroup(gUID);
                        if (userGroupInfo == null) continue;
                        Object[] objectArray = new Object[this.bV.size()];
                        block1: for (int i2 = 0; i2 < this.bV.size(); ++i2) {
                            Map.Entry entry = (Map.Entry)this.bV.get(i2);
                            if (((String)entry.getKey()).equals(UserDataSourceConfiguration.COLUMN_USERGROUP_ID)) {
                                objectArray[i2] = gUID.toString();
                                continue;
                            }
                            if (((String)entry.getKey()).equals(UserDataSourceConfiguration.COLUMN_USERGROUP_NAME)) {
                                objectArray[i2] = userGroupInfo.getDisplayName();
                                if (userGroupInfo.getParentID() == null) continue;
                                objectArray[i2] = this.bW.getGroup(userGroupInfo.getParentID()).getDisplayName() + "/" + String.valueOf(objectArray[i2]);
                                continue;
                            }
                            if (((String)entry.getKey()).equals(UserDataSourceConfiguration.COLUMN_USERGROUP_TYPE)) {
                                for (GroupTypeDef groupTypeDef : ServerPluginManager.getInstance().get(GroupTypeDef.class)) {
                                    GroupType groupType = groupTypeDef.getGroupType();
                                    if (!userGroupInfo.getType().equals((Object)groupType)) continue;
                                    objectArray[i2] = groupTypeDef.getDisplayName();
                                    continue block1;
                                }
                                continue;
                            }
                            if (((DataSourceUtils.ColumnInfoWithLabel)((Object)entry.getValue())).getColumnType() != 3) continue;
                            UserGroupField userGroupField = UsersAndGroups.getGroupFieldByKey((String)((String)entry.getKey()));
                            objectArray[i2] = DataSourceUtils.showDisplayValueForField(userGroupField) ? userGroupField.getFieldType().getDisplayValue(userGroupInfo.getValue(userGroupField)) : userGroupInfo.getValue(userGroupField);
                        }
                        this.getAllRows().add(objectArray);
                        return super.next();
                    }
                    return false;
                }
            };
            return new TableData((ResultSet)object3);
        }
        if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_GROUP_MEMBERSHIPS)) {
            string = UserGroupManager.getInstance();
            List<ColumnInfo> list5 = this.getColumns(ts);
            object3 = new SimpleResultSet(list5.stream().map(columnInfo -> columnInfo.getName()).collect(Collectors.toList()).toArray(new String[list5.size()]), (UserGroupManager)string, list5){
                private final Iterator<GUID> bP;
                private List<GUID> bX;
                private GUID bY;
                final /* synthetic */ UserGroupManager bW;
                final /* synthetic */ List bV;
                {
                    this.bW = userGroupManager;
                    this.bV = list;
                    super(stringArray);
                    this.bP = set.iterator();
                    this.bX = List.of();
                }

                public boolean next() throws SQLException {
                    GUID gUID;
                    GUID gUID2;
                    if (this.bX.isEmpty()) {
                        while (this.bP.hasNext()) {
                            gUID2 = this.bP.next();
                            gUID = this.bW.getGroup(gUID2);
                            if (gUID == null) continue;
                            Set set2 = gUID.getMemberIDs();
                            if (set2.isEmpty()) {
                                if (gUID.getParentID() != null) {
                                    set2 = this.bW.getGroup(gUID.getParentID()).getMemberIDs();
                                }
                                if (set2.isEmpty()) continue;
                            }
                            this.bX = new ArrayList<GUID>(set2);
                            this.bY = gUID2;
                            break;
                        }
                        if (this.bX.isEmpty()) {
                            return false;
                        }
                    }
                    gUID2 = new Object[this.bV.size()];
                    gUID = this.bX.remove(0);
                    for (int i2 = 0; i2 < this.bV.size(); ++i2) {
                        ColumnInfo columnInfo = (ColumnInfo)this.bV.get(i2);
                        if (columnInfo.getName().equals(UserDataSourceConfiguration.COLUMN_USER_GUID)) {
                            gUID2[i2] = gUID.toString();
                            continue;
                        }
                        if (!columnInfo.getName().equals(UserDataSourceConfiguration.COLUMN_USERGROUP_ID)) continue;
                        gUID2[i2] = this.bY.toString();
                    }
                    this.getAllRows().add(gUID2);
                    return super.next();
                }
            };
            return new TableData((ResultSet)object3);
        }
        throw new ReportException("Unknown database table: " + ts.getDatabaseIdentifier(), ReportErrorCode.invalidDataSourceFile.getErrorCodeNumber());
    }

    private static String a(String string, FieldValue fieldValue) {
        TakeoutDataRenderer takeoutDataRenderer = null;
        try {
            takeoutDataRenderer = (TakeoutDataRenderer)ServerPluginManager.getInstance().getSingleInstanceByName(TakeoutDataRenderer.class, string, true);
        }
        catch (IllegalStateException illegalStateException) {
            AdHocServerPlugin.LOGGER.error((Throwable)illegalStateException);
            return "";
        }
        return takeoutDataRenderer.render(fieldValue);
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        return Map.of("User", new TableSourceInfo(null, null, "User", 20), TABLE_NAME_USER_ADHOC, new TableSourceInfo(null, null, TABLE_NAME_USER_ADHOC, 20), TABLE_NAME_USER_GROUPS, new TableSourceInfo(null, null, TABLE_NAME_USER_GROUPS, 20), TABLE_NAME_USER_GROUP_MEMBERSHIPS, new TableSourceInfo(null, null, TABLE_NAME_USER_GROUP_MEMBERSHIPS, 20));
    }

    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        List<Object> list = new ArrayList<ColumnInfo>();
        if (ts.getDatabaseIdentifier().equals("User")) {
            list.add(new ColumnInfo("UserGUID", 11));
            list.add(new ColumnInfo("Label", 11));
            list.add(new ColumnInfo("FieldKey", 11));
            list.add(new ColumnInfo("Value", 11));
            list.add(new ColumnInfo("UserGUID", 11, 1, 12, 0));
        } else if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_ADHOC)) {
            list = this.l(ts.getDatabaseIdentifier()).stream().map(entry -> (DataSourceUtils.ColumnInfoWithLabel)((Object)((Object)entry.getValue()))).collect(Collectors.toList());
            list.add(new ColumnInfo(PROMPT_USER_SEARCH_CONDITIONS, 11, 1, 12, 0));
        } else if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_GROUPS)) {
            list = this.l(ts.getDatabaseIdentifier()).stream().map(entry -> (DataSourceUtils.ColumnInfoWithLabel)((Object)((Object)entry.getValue()))).collect(Collectors.toList());
        } else if (ts.getDatabaseIdentifier().equals(TABLE_NAME_USER_GROUP_MEMBERSHIPS)) {
            list.add(new ColumnInfo(COLUMN_USER_GUID, 11));
            list.add(new ColumnInfo(COLUMN_USERGROUP_ID, 11));
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private List<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> l(String string) {
        ArrayList<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>> arrayList = new ArrayList<Map.Entry<String, DataSourceUtils.ColumnInfoWithLabel>>();
        if (string.equals(TABLE_NAME_USER_ADHOC)) {
            arrayList.add(Map.entry(COLUMN_USER_GUID, new DataSourceUtils.ColumnInfoWithLabel(COLUMN_USER_GUID, AdHocServerPlugin.SERVER_MSG.getMsg("column_userguid", new Object[0]), 11)));
            arrayList.add(Map.entry(COLUMN_USER_NAME, new DataSourceUtils.ColumnInfoWithLabel(COLUMN_USER_NAME, AdHocServerPlugin.SERVER_MSG.getMsg("column_username", new Object[0]), 11)));
            arrayList.add(Map.entry(COLUMN_USER_ACTIVE, new DataSourceUtils.ColumnInfoWithLabel(COLUMN_USER_ACTIVE, AdHocServerPlugin.SERVER_MSG.getMsg("column_user_active", new Object[0]), 8)));
            arrayList.add(Map.entry(COLUMN_USER_LOCKED, new DataSourceUtils.ColumnInfoWithLabel(COLUMN_USER_LOCKED, AdHocServerPlugin.SERVER_MSG.getMsg("column_user_locked", new Object[0]), 8)));
        } else if (string.equals(TABLE_NAME_USER_GROUPS)) {
            arrayList.add(Map.entry(COLUMN_USERGROUP_ID, new DataSourceUtils.ColumnInfoWithLabel(COLUMN_USERGROUP_ID, AdHocServerPlugin.SERVER_MSG.getMsg("column_usergroupid", new Object[0]), 11)));
            arrayList.add(Map.entry(COLUMN_USERGROUP_NAME, new DataSourceUtils.ColumnInfoWithLabel(COLUMN_USERGROUP_NAME, AdHocServerPlugin.SERVER_MSG.getMsg("column_usergroupname", new Object[0]), 11)));
            arrayList.add(Map.entry(COLUMN_USERGROUP_TYPE, new DataSourceUtils.ColumnInfoWithLabel(COLUMN_USERGROUP_TYPE, AdHocServerPlugin.SERVER_MSG.getMsg("column_usergrouptype", new Object[0]), 11)));
        }
        @Nonnull List list = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        Collections.sort(list, (fieldDefinition, fieldDefinition2) -> fieldDefinition.getPriority() - fieldDefinition2.getPriority());
        for (FieldDefinition fieldDefinition3 : list) {
            if (fieldDefinition3.getDisplayType() == null || string.equals(TABLE_NAME_USER_ADHOC) && fieldDefinition3.getGroupingType() != Type.user || string.equals(TABLE_NAME_USER_GROUPS) && fieldDefinition3.getGroupingType() != Type.group || fieldDefinition3.getFieldKey() == null || fieldDefinition3.getLabel() == null || fieldDefinition3 instanceof UserFieldDefinition && !((UserFieldDefinition)fieldDefinition3).isAvailable(null) || fieldDefinition3 instanceof GroupFieldDefinition && !((GroupFieldDefinition)fieldDefinition3).isAvailable(null)) continue;
            UserField userField = null;
            if (string.equals(TABLE_NAME_USER_ADHOC)) {
                userField = UsersAndGroups.getFieldByKey((String)fieldDefinition3.getFieldKey());
            } else if (string.equals(TABLE_NAME_USER_GROUPS)) {
                userField = UsersAndGroups.getGroupFieldByKey((String)fieldDefinition3.getFieldKey());
            }
            if (userField == null) {
                AdHocServerPlugin.LOGGER.debug((Object)("No field for def " + fieldDefinition3.getFieldKey()));
                continue;
            }
            if (DataSourceUtils.showDisplayValueForField(userField)) {
                arrayList.add(Map.entry(fieldDefinition3.getFieldKey(), new DataSourceUtils.ColumnInfoWithLabel(fieldDefinition3.getFieldKey(), fieldDefinition3.getLabel(), 11)));
                continue;
            }
            int n2 = DataSourceUtils.apiFieldTypeToReportFieldType(userField);
            arrayList.add(Map.entry(fieldDefinition3.getFieldKey(), new DataSourceUtils.ColumnInfoWithLabel(fieldDefinition3.getFieldKey(), fieldDefinition3.getLabel(), n2)));
        }
        return arrayList;
    }

    public static AndSearchExpression buildSearchExpressionFromFilter(@Nonnull DataViewConditions filter) {
        return DataSourceUtils.buildSearchPhraseExpression(filter, TABLE_NAME_USER_ADHOC, string -> UsersAndGroups.getFieldByKey((String)string), UserManager.getInstance().getSearchEngine(), Map.of());
    }
}

