/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.renderer;

import com.inet.annotations.JsonData;
import com.inet.report.adhoc.server.api.renderer.AbstractFormatableColumn;
import com.inet.report.adhoc.server.api.renderer.SortOrder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class GroupData
extends AbstractFormatableColumn {
    @Nonnull
    private static final TimePeriod DEFAULT_TIME_PERIOD = TimePeriod.DAY;
    @Nonnull
    private SortOrder sortOrder;
    @Nonnull
    private TimePeriod timePeriod;

    private GroupData() {
    }

    public GroupData(@Nonnull String columnKey, @Nonnull SortOrder sortOrder) {
        this(columnKey, sortOrder, null, AbstractFormatableColumn.ValueFormat.UNFORMATTED);
    }

    public GroupData(@Nonnull String columnKey, @Nonnull SortOrder sortOrder, @Nonnull AbstractFormatableColumn.ValueFormat valueFormat) {
        this(columnKey, sortOrder, null, valueFormat);
    }

    public GroupData(@Nonnull String columnKey, @Nonnull SortOrder sortOrder, @Nullable TimePeriod timePeriod, @Nonnull AbstractFormatableColumn.ValueFormat valueFormat) {
        super(columnKey, valueFormat);
        this.sortOrder = sortOrder;
        this.timePeriod = timePeriod != null ? timePeriod : DEFAULT_TIME_PERIOD;
    }

    @Nonnull
    public SortOrder getSortOrder() {
        if (this.sortOrder == null) {
            this.sortOrder = SortOrder.ASCENDING;
        }
        return this.sortOrder;
    }

    public int getSortOrderCC() {
        return switch (this.getSortOrder()) {
            default -> throw new IncompatibleClassChangeError();
            case SortOrder.ASCENDING -> 0;
            case SortOrder.DESCENDING -> 1;
        };
    }

    @Nonnull
    public TimePeriod getTimePeriod() {
        if (this.timePeriod == null) {
            this.timePeriod = DEFAULT_TIME_PERIOD;
        }
        return this.timePeriod;
    }

    @JsonData
    public static enum TimePeriod {
        DAY,
        WEEK,
        TWO_WEEKS,
        HALF_MONTH,
        MONTH,
        QUARTER,
        HALF_YEAR,
        YEAR,
        SECOND,
        MINUTE,
        HOUR,
        AM_PM,
        WEEKDAY,
        CALENDAR_WEEK,
        MONTHLY_HALVES,
        MONTH_NAMES,
        QUARTER_NUMBERS,
        HALF_YEAR_NUMBERS,
        SECOND_NUMBERS,
        MINUTE_NUMBERS,
        HOUR_NUMBERS,
        TIME_OF_DAY;


        @Nullable
        public List<AbstractFormatableColumn.ValueFormat> getFormats() {
            return switch (this) {
                case DAY, WEEK, TWO_WEEKS, HALF_MONTH -> List.of(AbstractFormatableColumn.ValueFormat.DATE_FORMAT_SHORT, AbstractFormatableColumn.ValueFormat.DATE_FORMAT_MEDIUM, AbstractFormatableColumn.ValueFormat.DATE_FORMAT_LONG);
                case SECOND -> List.of(AbstractFormatableColumn.ValueFormat.DATETIME_FORMAT_MEDIUM, AbstractFormatableColumn.ValueFormat.DATETIME_FORMAT_LONG, AbstractFormatableColumn.ValueFormat.TIME_FORMAT_MEDIUM, AbstractFormatableColumn.ValueFormat.TIME_FORMAT_LONG);
                case MINUTE, HOUR, AM_PM -> List.of(AbstractFormatableColumn.ValueFormat.DATETIME_FORMAT_SHORT, AbstractFormatableColumn.ValueFormat.DATETIME_FORMAT_MEDIUM, AbstractFormatableColumn.ValueFormat.DATETIME_FORMAT_LONG, AbstractFormatableColumn.ValueFormat.TIME_FORMAT_SHORT, AbstractFormatableColumn.ValueFormat.TIME_FORMAT_MEDIUM, AbstractFormatableColumn.ValueFormat.TIME_FORMAT_LONG);
                default -> null;
            };
        }
    }
}

