/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.api.dataview;

import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.error.ErrorCode;
import com.inet.report.Engine;
import com.inet.report.ReportDataHandler;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.database.DatabaseUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@PublicApi
public class SimpleDataView
implements DataView {
    @Nonnull
    private @Nonnull Map<@Nonnull String, @Nonnull LocalizedKey> cf = new HashMap<String, LocalizedKey>();
    @Nonnull
    private Engine cg;
    private ReportDataHandler ch;

    public SimpleDataView(@Nonnull @Nonnull List<@Nonnull LocalizedKey> fields, @Nonnull Engine engine) {
        for (LocalizedKey localizedKey : fields) {
            this.cf.put(localizedKey.getKey().toLowerCase(), localizedKey);
        }
        this.cg = Objects.requireNonNull(engine);
    }

    @Override
    @Nonnull
    public String getFieldDisplayName(@Nonnull String fieldKey) {
        String string;
        LocalizedKey localizedKey = this.cf.get(fieldKey.toLowerCase());
        if (localizedKey != null && (string = localizedKey.getDisplayName()) != null) {
            return string;
        }
        int n2 = fieldKey.lastIndexOf(46);
        if (n2 >= 0 && n2 + 1 < fieldKey.length()) {
            return fieldKey.substring(n2 + 1);
        }
        return fieldKey;
    }

    @Override
    @Nonnull
    public ReportDataHandler getDataProvider() {
        try {
            ReportDataHandler reportDataHandler = this.ch;
            if (reportDataHandler == null) {
                this.ch = reportDataHandler = DatabaseUtils.getAdHocData((Engine)this.cg);
            }
            return reportDataHandler;
        }
        catch (Exception exception) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)exception);
        }
    }

    @Override
    @Nonnull
    public Engine getEngine() {
        return this.cg;
    }
}

