/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.adhoc.server.renderer.chart.model;

import com.inet.annotations.JsonData;
import com.inet.report.adhoc.server.renderer.chart.j;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class RadarChartDataset {
    @Nonnull
    private String type = "radar";
    private List<Object> data = new ArrayList<Object>();
    private Map<String, Object> areaStyle = new HashMap<String, Object>();

    public RadarChartDataset(@Nonnull @Nonnull List<@Nonnull String> labels, @Nonnull @Nonnull List<@Nullable Double @Nonnull []> values, @Nonnull @Nonnull List<@Nullable String @Nonnull []> formattedValues, @Nonnull @Nonnull List<@Nonnull Color> colors, boolean fill) {
        for (int i2 = 0; i2 < values.size(); ++i2) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", labels.get(i2));
            hashMap.put("value", values.get(i2));
            hashMap.put("formattedValue", formattedValues.get(i2));
            Color color = colors.get(i2 % colors.size());
            hashMap.put("itemStyle", Map.of("color", j.a(color)));
            this.data.add(hashMap);
        }
        double d2 = fill ? 0.3 : 0.0;
        this.areaStyle.put("opacity", d2);
    }
}

